# -*- coding: utf-8 -*-

"""
ImageNet Generator

credits:
    https://github.com/GT-RIPL/AlwaysBeDreaming-DFCIL
    https://github.com/VainF/Data-Free-Adversarial-Distillation
"""

import torch
import torch.nn as nn
from typing import List

class Generator(nn.Module):
    def __init__(self, zdim, in_channel, img_sz, protos: List[torch.Tensor]):
        super().__init__()

        self.z_dim = zdim
        self.init_size = img_sz // (2 ** 5)
        self.l0 = nn.Linear(512, zdim)
        self.l1 = nn.Sequential(nn.Linear(zdim, 64 * self.init_size ** 2))

        self.conv_blocks0 = nn.Sequential(
            nn.BatchNorm2d(64),
        )
        self.conv_blocks1 = nn.Sequential(
            nn.Conv2d(64, 64, 3, stride=1, padding=1),
            nn.BatchNorm2d(64, 0.8),
            nn.LeakyReLU(0.2, inplace=True),
        )
        self.conv_blocks2 = nn.Sequential(
            nn.Conv2d(64, 64, 3, stride=1, padding=1),
            nn.BatchNorm2d(64, 0.8),
            nn.LeakyReLU(0.2, inplace=True),
        )
        self.conv_blocks3 = nn.Sequential(
            nn.Conv2d(64, 64, 3, stride=1, padding=1),
            nn.BatchNorm2d(64, 0.8),
            nn.LeakyReLU(0.2, inplace=True),
        )
        self.conv_blocks4 = nn.Sequential(
            nn.Conv2d(64, 64, 3, stride=1, padding=1),
            nn.BatchNorm2d(64, 0.8),
            nn.LeakyReLU(0.2, inplace=True),
        )
        self.conv_blocks5 = nn.Sequential(
            nn.Conv2d(64, 64, 3, stride=1, padding=1),
            nn.BatchNorm2d(64, 0.8),
            nn.LeakyReLU(0.2, inplace=True),
        )
        self.conv_blocks6 = nn.Sequential(
            nn.Conv2d(64, in_channel, 3, stride=1, padding=1),
            nn.Tanh(),
            nn.BatchNorm2d(in_channel, affine=False),
        )

        self.protos = protos

    def forward(self, targets: torch.Tensor):
        z = self.protos[targets]
        z = torch.randn(z.shape).to(z.device) * 0.5 + z
        z = self.l0(z)
        out = self.l1(z)
        out = out.view(out.shape[0], 64, self.init_size, self.init_size)
        img = self.conv_blocks0(out)
        img = nn.functional.interpolate(img, scale_factor=2)
        img = self.conv_blocks1(img)
        img = nn.functional.interpolate(img, scale_factor=2)
        img = self.conv_blocks2(img)
        img = nn.functional.interpolate(img, scale_factor=2)
        img = self.conv_blocks3(img)
        img = nn.functional.interpolate(img, scale_factor=2)
        img = self.conv_blocks4(img)
        img = nn.functional.interpolate(img, scale_factor=2)
        img = self.conv_blocks5(img)
        img = self.conv_blocks6(img)
        return img

    def sample(self, targets: torch.Tensor):
        X = self.forward(targets)
        return X


def IMNET_GEN(protos: List[torch.Tensor]):
    return Generator(zdim=1000, in_channel=3, img_sz=224, protos=protos)
