import os
from .clip_encoder import CLIPVisionTower
from .esm_encoder import ESMEncoder

def build_protein_tower(protein_tower_cfg, **kwargs):
    protein_tower = getattr(protein_tower_cfg, "mm_protein_tower", getattr(protein_tower_cfg, 'protein_tower', None))
    # print(protein_tower_cfg, protein_tower)
    is_absolute_path_exists = os.path.exists(protein_tower)
    if is_absolute_path_exists or "facebook" in protein_tower:
        return ESMEncoder(protein_tower, 
                          protein_tower_cfg.protein_max_len, 
                          select_layer=protein_tower_cfg.mm_protein_select_layer, 
                          **kwargs)
        

def build_vision_tower(vision_tower_cfg, **kwargs):
    vision_tower = getattr(vision_tower_cfg, 'mm_vision_tower', getattr(vision_tower_cfg, 'vision_tower', None))
    is_absolute_path_exists = os.path.exists(vision_tower)
    if is_absolute_path_exists or vision_tower.startswith("openai") or vision_tower.startswith("laion"):
        return CLIPVisionTower(vision_tower, args=vision_tower_cfg, **kwargs)

    raise ValueError(f'Unknown vision tower: {vision_tower}')
