import torch


def create_optimizers(learner_model, learner_generator_model, total_frames, FLAGS):
    optimizer = torch.optim.RMSprop(
        learner_model.parameters(),
        lr=FLAGS.lr,
        momentum=FLAGS.momentum,
        eps=FLAGS.epsilon,
        alpha=FLAGS.alpha,
    )

    generator_optimizer = torch.optim.RMSprop(
        learner_generator_model.parameters(),
        lr=FLAGS.generator_lr,
        momentum=FLAGS.momentum,
        eps=FLAGS.epsilon,
        alpha=FLAGS.alpha,
    )

    grounder_optimizer = torch.optim.RMSprop(
        learner_generator_model.parameters(),
        lr=FLAGS.generator_lr,
        momentum=FLAGS.momentum,
        eps=FLAGS.epsilon,
        alpha=FLAGS.alpha,
    )

    def lr_lambda(epoch):
        return (
            1
            - min(
                (epoch * FLAGS.unroll_length * FLAGS.batch_size),
                total_frames,
            )
            / total_frames
        )

    scheduler = torch.optim.lr_scheduler.LambdaLR(optimizer, lr_lambda)
    generator_scheduler = torch.optim.lr_scheduler.LambdaLR(
        generator_optimizer, lr_lambda
    )
    grounder_scheduler = torch.optim.lr_scheduler.LambdaLR(
        grounder_optimizer, lr_lambda
    )

    return (
        optimizer,
        generator_optimizer,
        grounder_optimizer,
        scheduler,
        generator_scheduler,
        grounder_scheduler,
    )
