# Supplementary Code Repository 

## Info 
This repo contains a small subset of important files used in our code implementation. 

## Contents

1. **supp_material/**: 
   - `narrative_generation.py`: Uses ToT prompting to generate narratives subject to constraints.  

2. **LIIPA/**: Files used to classify character portrayal using LLMs
   - `run_pipeline.py`: Top-level file to uncover character portrayal. 
   - `tot_prompting.py`: Stand-alone script for using ToT prompting to uncover portrayal.
   - `ltm_prompting.py`: Stand-alone script for using LtM prompting to uncover portrayal.
   - `generate_inferences.py`: Used by run_pipeline.py to uncover portrayal using DP,CoT, and other prompting strategies.
   - `get_lexicon_scores.py`: Used by run_pipeline.py to evaluate LLM/COMET generated character attribute word lists.

3. **experiments/**: A few notebooks containing the fairness results from our paper. 

4. **data/**: 
   - `narratives.csv`: A small 50 sample subset from our dataset ImPortPrompts. 
   - `prompt_library.json`: Contains our prompts.
     -  "evaluate" contains LLM-as-a-judge prompts
     -  "generate_inferences" contains our classification prompts
