export GLOG_minloglevel=2
export MAGNUM_LOG=quiet

flag1="--exp_name release_r2r_adapters_rgb_final
      --run-type train
      --exp-config run_r2r/iter_train.yaml
      CHECKPOINT_FOLDER rgb_adapters
      SIMULATOR_GPU_IDS [0,1,2,3]
      TORCH_GPU_IDS [0,1,2,3]
      GPU_NUMBERS 4
      NUM_ENVIRONMENTS 2
      IL.iters 15000
      IL.lr 1e-5
      IL.log_every 200
      IL.ml_weight 1.0
      IL.sample_ratio 0.75
      IL.decay_interval 3000
      IL.load_from_ckpt False
      IL.is_requeue True
      IL.waypoint_aug  True
      TASK_CONFIG.SIMULATOR.HABITAT_SIM_V0.ALLOW_SLIDING True
      MODEL.pretrained_path pretrained/ETP/mlm.sap_r2r/ckpts/model_step_82500.pt
      "

flag2=" --exp_name release_r2r
      --run-type eval
      --exp-config run_r2r/iter_train.yaml
      SIMULATOR_GPU_IDS [0,1]
      TORCH_GPU_IDS [0,1]
      GPU_NUMBERS 2
      NUM_ENVIRONMENTS 8
      TASK_CONFIG.SIMULATOR.HABITAT_SIM_V0.ALLOW_SLIDING True
      EVAL.CKPT_PATH_DIR /data3/yash/ETPNav/ETPNav/teacher_student_RGB_image_corruption_distrirelease_r2r_image_corruption_distri/ckpt.iter12000.pth
      IL.back_algo control
      "

flag3="--exp_name release_r2r
      --run-type inference
      --exp-config run_r2r/iter_train.yaml
      SIMULATOR_GPU_IDS [0,1]
      TORCH_GPU_IDS [0,1]
      GPU_NUMBERS 2
      NUM_ENVIRONMENTS 8
      TASK_CONFIG.SIMULATOR.HABITAT_SIM_V0.ALLOW_SLIDING True
      INFERENCE.CKPT_PATH data/logs/checkpoints/release_r2r/ckpt.iter12000.pth
      INFERENCE.PREDICTIONS_FILE preds.json
      IL.back_algo control
      "

flag4="--exp_name release_r2r_depth_adapters_lr
      --run-type train
      --exp-config run_r2r/iter_train.yaml
      CHECKPOINT_FOLDER depth_adapters_robust_lr
      NUM_ENVIRONMENTS 1
      MODEL.DEPTH_ENCODER.use_depth_adapters True
      MODEL.DEPTH_ENCODER.depth_adapter_width 64
      MODEL.DEPTH_ENCODER.depth_adapter_dropout 0.1
      MODEL.DEPTH_ENCODER.depth_adapter_stages [2,3]
      IL.load_from_ckpt True
      IL.ckpt_to_load /data3/yash/ETPNav/ETPNav/data/logs/checkpoints/release_r2r_old/ckpt.iter12000.pth
      IL.iters 5000
      IL.lr 1e-5
      IL.log_every 200
      IL.ml_weight 1.0
      IL.sample_ratio 0.75
      IL.decay_interval 1000
      IL.waypoint_aug True
      TASK_CONFIG.SIMULATOR.HABITAT_SIM_V0.ALLOW_SLIDING True
      MODEL.pretrained_path pretrained/ETP/mlm.sap_r2r/ckpts/model_step_82500.pt
      "

flag5="--exp_name release_r2r_rgb_adapters
      --run-type train
      --exp-config run_r2r/iter_train.yaml
      CHECKPOINT_FOLDER rgb_adapters_robust
      SIMULATOR_GPU_IDS [0]
      TORCH_GPU_IDS [0]
      GPU_NUMBERS 1
      NUM_ENVIRONMENTS 2
      MODEL.spatial_output True
      MODEL.RGB_ENCODER.cnn_type TorchVisionResNet50
      MODEL.RGB_ENCODER.use_rgb_adapters True
      MODEL.RGB_ENCODER.rgb_adapter_width 64
      MODEL.RGB_ENCODER.rgb_adapter_dropout 0.1
      MODEL.RGB_ENCODER.rgb_adapter_stages [2,3]
      MODEL.RGB_ENCODER.train_rgb_norm_with_adapters True
      MODEL.RGB_ENCODER.use_rgb_fusion_gate True
      MODEL.DEPTH_ENCODER.use_depth_adapters False
      IL.load_from_ckpt True
      IL.ckpt_to_load /data3/yash/ETPNav/ETPNav/data/logs/checkpoints/release_r2r_old/ckpt.iter12000.pth
      IL.iters 5000
      IL.lr 1e-5
      IL.log_every 200
      IL.ml_weight 1.0
      IL.sample_ratio 0.75
      IL.decay_interval 1000
      IL.waypoint_aug True
      TASK_CONFIG.SIMULATOR.HABITAT_SIM_V0.ALLOW_SLIDING True
      MODEL.pretrained_path pretrained/ETP/mlm.sap_r2r/ckpts/model_step_82500.pt
      "

mode=$1
case $mode in 
      train)
      echo "###### train mode ######"
      python -m torch.distributed.launch --nproc_per_node=4 --master_port $2 run.py $flag1
      ;;
      eval)
      echo "###### eval mode ######"

      # 1. 在这里定义一个数组，包含所有你想评估的 checkpoint 路径
      CHECKPOINTS=(
            "/data3/yash/ETPNav/ETPNav/rgb_adapters_robustrelease_r2r_rgb_adapters/ckpt.iter2000.pth"
          # 在这里继续添加更多 checkpoint 路径...
      )

      # 2. 将 flag2 中不变的部分提取出来
      common_flags=" --exp_name release_r2r
        --run-type eval
        --exp-config run_r2r/iter_train.yaml
        SIMULATOR_GPU_IDS [0]
        TORCH_GPU_IDS [0]
        GPU_NUMBERS 1
        NUM_ENVIRONMENTS 2
        TASK_CONFIG.SIMULATOR.HABITAT_SIM_V0.ALLOW_SLIDING True
        IL.back_algo control
        MODEL.spatial_output True
        MODEL.RGB_ENCODER.cnn_type TorchVisionResNet50
        MODEL.RGB_ENCODER.use_rgb_adapters True
        MODEL.RGB_ENCODER.rgb_adapter_width 64
        MODEL.RGB_ENCODER.rgb_adapter_dropout 0.1
        MODEL.RGB_ENCODER.rgb_adapter_stages [2,3]
        MODEL.RGB_ENCODER.train_ln_with_adapters True
        MODEL.DEPTH_ENCODER.use_depth_adapters False
        MODEL.RGB_ENCODER.use_rgb_adapters True
      MODEL.RGB_ENCODER.rgb_adapter_width 64
      MODEL.RGB_ENCODER.rgb_adapter_dropout 0.1
      MODEL.RGB_ENCODER.rgb_adapter_stages [2,3]
      MODEL.RGB_ENCODER.train_rgb_norm_with_adapters True
      MODEL.RGB_ENCODER.use_rgb_fusion_gate True
      MODEL.DEPTH_ENCODER.use_depth_adapters False
        IL.load_from_ckpt True
        IL.ckpt_to_load data/logs/checkpoints/release_r2r/ckpt.iter12000.pth
        "
      
      # 3. 循环遍历数组中的每个 checkpoint 路径
      for ckpt in "${CHECKPOINTS[@]}"; do
        echo " " # 加个空行，方便区分
        echo ">>>>>>>>>> 正在评估 Checkpoint: $ckpt <<<<<<<<<<<<"
        
        # 4. 执行评估命令，注意我们将变化的 EVAL.CKPT_PATH_DIR 部分放在了命令的最后
        python run.py $common_flags EVAL.CKPT_PATH_DIR $ckpt
      done
      ;;
      infer)
      echo "###### infer mode ######"
      python -m torch.distributed.launch --nproc_per_node=2 --master_port $2 run.py $flag3
      ;;
      adapt)
      echo "###### depth adapter training mode ######"
      echo "Training with depth adapters for corruption robustness..."
      echo "Using 4 GPUs, 2 environments per GPU"
      echo "Loading from: /data3/yash/ETPNav/ETPNav/data/logs/checkpoints/release_r2r_old/ckpt.iter12000.pth"
      python run.py $flag4
      ;;
      rgb_adapt)
      echo "###### RGB adapter training mode ######"
      echo "Training with RGB ConvAdapters for corruption robustness..."
      echo "Using ResNet50 with ConvAdapters on stages 2 and 3"
      echo "Loading from: /data3/yash/ETPNav/ETPNav/data/logs/checkpoints/release_r2r_old/ckpt.iter12000.pth"
      python run.py $flag5
      ;;
esac