function update_estimator!(mdp::TSRBirthDeathMDP,
                           tsr::TSRState, sarsa::SARSA)
    @unpack s, a, r, snew, anew = sarsa
    if r > 0
        δ = id2state(mdp, s) .- id2state(mdp, snew)
        tsr.Ns[a, argmax(δ)] += 1
    end
    TSRState(tsr.t + 1, tsr.Ns)
end

function tsri_k(mdp::TSRBirthDeathMDP, tsr::TSRState, k::Int64)
    @unpack aL, aC, λ, μ = mdp
    @unpack t, Ns = tsr
    β = exp(- λ / μ)
    probs = [1 - aC, aC] * [1 - aL, aL]'
    ests = Ns ./ probs ./ t
    est1 = ests[2, 2] - ests[1, 2] - k * (1 - β) * (ests[1, 1] - ests[1, 2])
    est2 = ests[2, 2] - ests[2, 1] - k * β * (ests[1, 1] - ests[2, 1])
    β * est1 + (1 - β) * est2
end

function summarize_estimator(mdp::TSRBirthDeathMDP,
                             stats::PathStats, tsr::TSRState; kwargs...)
    @unpack t, Ns = tsr
    @unpack aL, aC = mdp
    naive_tsr = (Ns[2, 2] / (aL * aC) - (sum(Ns) - Ns[2, 2]) / (1 - aL * aC)) / t
    [Dict(:t => t, :estimator => "naive", :estimate => naive_tsr),
     Dict(:t => t, :estimator => "tsri1", :estimate => tsri_k(mdp, tsr, 1)),
     Dict(:t => t, :estimator => "tsri2", :estimate => tsri_k(mdp, tsr, 2))]
end

function add_pair!(P::SparseMatrixCSC{Float64, Int64},
                   pair::Pair{Tuple{Int64, Int64}, Float64})
    (i, j), v = pair
    P[i, j] = v
    P
end

transition_matrix(mdp::TSRBirthDeathMDP) =
    (1 - mdp.aC) * transition_matrix(mdp, 1) +
    mdp.aC * transition_matrix(mdp, 2)

transition_matrix(mdp::TSRBirthDeathMDP, a::Int64) =
    1:num_states(mdp) |>
        Map(s -> transition_probs(mdp, s, a)) |>
        Cat() |>
        foldxl(add_pair!; init=spzeros(num_states(mdp), num_states(mdp)))

function transition_probs(mdp::TSRBirthDeathMDP, s::Int64, a::Int64)
    results = marginalize(scenario_tree(mdp, id2state(mdp, s), a))
    [(s, state2id(mdp, k)) => v for (k, v) in results]
end
