library(data.table)

n <- 30000
setup <- 5 # default
J <- 10 # default
args <- commandArgs(trailingOnly = TRUE)
for (arg in args) {
  if (grepl("^--setup=", arg)) {   # <-- was wrong in your code
    val <- sub("^--setup=", "", arg)
    setup <- as.integer(val)
  }
  if (grepl("^--J=", arg)) {   # <-- was wrong in your code
    val <- sub("^--J=", "", arg)
    J <- as.integer(val)
  }
}
if(is.na(J)){matched = 0} else{matched = 1}

all_files <- list.files(
  path = sprintf("../Results_Boots_Single_Setup%d/MatchJ%s/", setup, J),
  full.names = TRUE
)
setDTthreads(0)  
dt <- rbindlist(lapply(all_files, fread), use.names = TRUE, fill = TRUE, idcol = "src")

folder_path <- '../Results_LR_Summary'

if (!dir.exists(folder_path)) {
  dir.create(folder_path, recursive = TRUE)
}

write.table(dt,
            file = sprintf('../Results_LR_Summary/setup%d_J%s.txt',
                           setup, J),
            row.names = FALSE, col.names = TRUE,
            quote = FALSE, sep = "\t")