# 🏆 The Best Machine Learning Engineering Agent!

# 🌟 Introduction

R&D-Agent aims to automate the most critical and valuable aspects of the industrial R&D process, and we begin with focusing on the data-driven scenarios to streamline the development of models and data. 
Methodologically, we have identified a framework with two key components: 'R' for proposing new ideas and 'D' for implementing them.
We believe that the automatic evolution of R&D will lead to solutions of significant industrial value.

# ⚡ Quick start

### RD-Agent currently only supports Linux.

You can try above demos by running the following command:

### 🐳 Docker installation.
Users must ensure Docker is installed before attempting most scenarios. Please refer to the [official 🐳Docker page](https://docs.docker.com/engine/install/) for installation instructions.
Ensure the current user can run Docker commands **without using sudo**. You can verify this by executing `docker run hello-world`.

### 🐍 Create a Conda Environment
- Create a new conda environment with Python (3.10 and 3.11 are well-tested in our CI):
  ```sh
  conda create -n rdagent python=3.10
  ```
- Activate the environment:
  ```sh
  conda activate rdagent
  ```

### 🛠️ Install the R&D-Agent

#### For Users
- You can directly install the R&D-Agent package from PyPI:
  ```sh
  pip install rdagent
  ```

#### For Developers
- If you want to try the latest version or contribute to RD-Agent, you can install it from the source and follow the development setup:
  ```sh
  cd RD-Agent
  make dev
  ```

### 💊 Health check
- rdagent provides a health check that currently checks two things.
  - whether the docker installation was successful.
  ```sh
  rdagent health_check --no-check-env
  ```


### ⚙️ Configuration
- The demos requires following ability:
  - ChatCompletion
  - json_mode
  - embedding query

- **Using LiteLLM (Default)**: We now support LiteLLM as a backend for integration with multiple LLM providers. You can configure in multiple ways:

  **Option 1: Unified API base for both models**

  *Configuration Example: `OpenAI` Setup :*

  ```bash
  cat << EOF  > .env
  # Set to any model supported by LiteLLM.
  CHAT_MODEL=gpt-4o 
  EMBEDDING_MODEL=text-embedding-3-small
  # Configure unified API base
  OPENAI_API_BASE=<your_unified_api_base>
  OPENAI_API_KEY=<replace_with_your_openai_api_key>
  ```

  *Configuration Example: `Azure OpenAI` Setup :*

  > Before using this configuration, please confirm in advance that your `Azure OpenAI API key` supports `embedded models`.

  ```bash
  cat << EOF  > .env
  EMBEDDING_MODEL=azure/<Model deployment supporting embedding>
  CHAT_MODEL=azure/<your deployment name>
  AZURE_API_KEY=<replace_with_your_openai_api_key>
  AZURE_API_BASE=<your_unified_api_base>
  AZURE_API_VERSION=<azure api version>
  ```

  **Option 2: Separate API bases for Chat and Embedding models**
  ```bash
  cat << EOF  > .env
  # Set to any model supported by LiteLLM.
  # Configure separate API bases for chat and embedding
  
  # CHAT MODEL:
  CHAT_MODEL=gpt-4o 
  OPENAI_API_BASE=<your_chat_api_base>
  OPENAI_API_KEY=<replace_with_your_openai_api_key>

  # EMBEDDING MODEL:
  EMBEDDING_MODEL=
  LITELLM_PROXY_API_KEY=
  LITELLM_PROXY_API_BASE=
  ```

- If your environment configuration is complete, please execute the following commands to check if your configuration is valid. This step is necessary.

  ```bash
  rdagent health_check
  ```

### 🚀 Run the Application

- Run the **Automated Quantitative Trading & Iterative Factors Model Joint Evolution**: self-loop factor & model proposal and implementation application
  ```sh
  rdagent fin_quant
  ```

- Run the **Automated Quantitative Trading & Iterative Factors Evolution**: self-loop factor proposal and implementation application
  ```sh
  rdagent fin_factor
  ```

- Run the **Automated Quantitative Trading & Iterative Model Evolution**: self-loop model proposal and implementation application
  ```sh
  rdagent fin_model
  ```

- Run the **Automated Quantitative Trading & Factors Extraction from Financial Reports**:  Run the factor extraction and implementation application based on financial reports
  ```sh
  # 1. Generally, you can run this scenario using the following command:
  rdagent fin_factor_report --report-folder=<Your financial reports folder path>

  # 2. Specifically, you need to prepare some financial reports first. You can follow this concrete example:
  unzip all_reports.zip -d git_ignore_folder/reports
  rdagent fin_factor_report --report-folder=git_ignore_folder/reports
  ```

- Run the **Automated Model Research & Development Copilot**: model extraction and implementation application
  ```sh
  # 1. Generally, you can run your own papers/reports with the following command:
  rdagent general_model <Your paper URL>

  # 2. Specifically, you can do it like this. For more details and additional paper examples, use `rdagent general_model -h`:
  rdagent general_model  <pdf_link>
  ```

- Run the **Automated Medical Prediction Model Evolution**: Medical self-loop model proposal and implementation application

  ```bash
  # Generally, you can run the data science program with the following command:
  rdagent data_science --competition <your competition name>

  # Specifically, you need to create a folder for storing competition files (e.g., competition description file, competition datasets, etc.), and configure the path to the folder in your environment. In addition, you need to use chromedriver when you download the competition descriptors, which you can follow for this specific example:

  # 1. Download the dataset, extract it to the target folder.
  unzip arf-12-hours-prediction-task.zip -d ./git_ignore_folder/ds_data/

  # 2. Configure environment variables in the `.env` file
  dotenv set DS_LOCAL_DATA_PATH "$(pwd)/git_ignore_folder/ds_data"
  dotenv set DS_CODER_ON_WHOLE_PIPELINE True
  dotenv set DS_IF_USING_MLE_DATA False
  dotenv set DS_SAMPLE_DATA_BY_LLM False
  dotenv set DS_SCEN rdagent.scenarios.data_science.scen.DataScienceScen

  # 3. run the application
  rdagent data_science --competition arf-12-hours-prediction-task
  ```


- Run the **Automated Kaggle Model Tuning & Feature Engineering**:  self-loop model proposal and feature engineering implementation application <br />
  > Using **tabular-playground-series-dec-2021** as an example. <br />
  > 1. Register and login on the [Kaggle](https://www.kaggle.com/) website. <br />
  > 2. Configuring the Kaggle API. <br />
  > (1) Click on the avatar (usually in the top right corner of the page) -> `Settings` -> `Create New Token`, A file called `kaggle.json` will be downloaded. <br />
  > (2) Move `kaggle.json` to `~/.config/kaggle/` <br />
  > (3) Modify the permissions of the kaggle.json file. Reference command: `chmod 600 ~/.config/kaggle/kaggle.json` <br />
  > 3. Join the competition: Click `Join the competition` -> `I Understand and Accept` at the bottom of the [competition details page](https://www.kaggle.com/competitions/tabular-playground-series-dec-2021/data).
  ```bash
  # Generally, you can run the Kaggle competition program with the following command:
  rdagent data_science --competition <your competition name>

  # 1. Configure environment variables in the `.env` file
  mkdir -p ./git_ignore_folder/ds_data
  dotenv set DS_LOCAL_DATA_PATH "$(pwd)/git_ignore_folder/ds_data"
  dotenv set DS_CODER_ON_WHOLE_PIPELINE True
  dotenv set DS_IF_USING_MLE_DATA True
  dotenv set DS_SAMPLE_DATA_BY_LLM True
  dotenv set DS_SCEN rdagent.scenarios.data_science.scen.KaggleScen

  # 2. run the application
  rdagent data_science --competition tabular-playground-series-dec-2021
  ```

### 🖥️ Monitor the Application Results
- You can run the following command for our demo program to see the run logs.

  ```sh
  rdagent ui --port 19899 --log-dir <your log folder like "log/"> --data-science
  ```

- About the `data_science` parameter: If you want to see the logs of the data science scenario, set the `data_science` parameter to `True`; otherwise set it to `False`.
 
- Although port 19899 is not commonly used, but before you run this demo, you need to check if port 19899 is occupied. If it is, please change it to another port that is not occupied.

  You can check if a port is occupied by running the following command.

  ```sh
  rdagent health_check --no-check-env --no-check-docker
  ```
