#!/bin/bash -x

set -euo pipefail

project_home={project_home}

export HTTP_PROXY=$http_proxy
export HTTPS_PROXY=$https_proxy

cd "$project_home"
source .venv/bin/activate

ml cuda/12.9 || true

mkdir -p /tmp/.triton/autotune

export TRITON_CACHE_DIR=/tmp/.triton/autotune


export WANDB_RESUME={wandb_resume}
export WANDB_PROJECT={wandb_project}
export WANDB_ENTITY={wandb_entity}
export WANDB_RUN_GROUP={wandb_group}
export WANDB_DIR={wandb_dir}
export WANDB_NAME={wandb_run_name}
export TORCH_INDUCTOR_DISABLE_CACHE=1
export TORCHDYNAMO_VERBOSE=1

PYTHONPATH=$PWD python exp/state_tracking/src/main.py --config-path={config_path} --config-name=config.yaml


