import numpy as np
import matplotlib.pyplot as plt

theta = np.linspace(0, 2 * np.pi, 1000)
x_circle = np.cos(theta)
y_circle = np.sin(theta)

n_points = 30

# Figure 1: Fixed angles
theta1_fixed = 2 * np.pi * np.linspace(0, 1, 20)
x_fixed = np.cos(theta1_fixed)
y_fixed = np.sin(theta1_fixed)

fig1, ax1 = plt.subplots(figsize=(5, 5), facecolor="none")
ax1.set_facecolor("none")
circle1 = plt.Circle((0, 0), 1, color="white", zorder=0)
ax1.add_patch(circle1)
ax1.plot(x_circle, y_circle, lw=10, color="black", alpha=1, zorder=1)
ax1.scatter(x_fixed, y_fixed, color="red", s=500, alpha=1, zorder=2)
ax1.axis("equal")
ax1.axis("off")
plt.tight_layout()
plt.savefig("norm_sel_rope_fixed.png", dpi=500, bbox_inches="tight", transparent=True)

# Figure 2: Random angles
# np.random.seed(42)  # for reproducibility
theta1_random = 2 * np.pi * np.random.rand(n_points + 20)
x_random = np.cos(theta1_random)
y_random = np.sin(theta1_random)

fig2, ax2 = plt.subplots(figsize=(5, 5), facecolor="none")
ax2.set_facecolor("none")
circle2 = plt.Circle((0, 0), 1, color="white", zorder=0)
ax2.add_patch(circle2)
ax2.plot(x_circle, y_circle, lw=10, color="black", alpha=1, zorder=1)
ax2.scatter(x_random, y_random, color="red", s=500, alpha=1, zorder=2)
ax2.axis("equal")
ax2.axis("off")
plt.tight_layout()
plt.savefig("norm_sel_rope_random.png", dpi=500, bbox_inches="tight", transparent=True)

# Figure 3: Random angles + decay
# np.random.seed(42)  # same random angles as above
radii_decay = np.sqrt(np.random.rand(n_points + 20))  # sqrt for uniform distribution
x_decay = radii_decay * np.cos(theta1_random)
y_decay = radii_decay * np.sin(theta1_random)

fig3, ax3 = plt.subplots(figsize=(5, 5), facecolor="none")
ax3.set_facecolor("none")
circle3 = plt.Circle((0, 0), 1, color="white", zorder=0)
ax3.add_patch(circle3)
ax3.plot(x_circle, y_circle, lw=10, color="black", alpha=1, zorder=1)
ax3.scatter(x_decay, y_decay, color="red", s=500, alpha=1, zorder=2)
ax3.axis("equal")
ax3.axis("off")
plt.tight_layout()
plt.savefig(
    "norm_sel_rope_random_decay.png", dpi=500, bbox_inches="tight", transparent=True
)
