#!/bin/bash
#SBATCH -A test                  # 自己所属的账户 (不要改)
#SBATCH -J fedspa               # 所运行的任务名称 (自己取)
#SBATCH -N 1                    # 占用的节点数（根据代码要求确定）
#SBATCH --ntasks-per-node=24     # 运行的进程数（根据代码要求确定）
#SBATCH --cpus-per-task=4       # 每个进程的CPU核数 （根据代码要求确定）
#SBATCH --gres=gpu:8            # 占用的GPU卡数 （根据代码要求确定）
#SBATCH -p su1                  # 任务运行所在的分区 (根据代码要求确定，gpu为gpu分区，gpu4为4卡gpu分区，cpu为cpu分区)
#SBATCH -t 0-48:00:00            # 运行的最长时间 day-hour:minute:second
#SBATCH -o out_scream10.out        # 打印输出的文件
# 运行代码
#cd standalone/fedavg
#nohup python main_fedavg_ft.py --epochs 3 --tag test4 &
#nohup python main_ditto.py --epochs 3 --tag test3 &
#cd ../fedspa
#nohup python main_fedspa.py --dense_ratio 0.5  --epochs 3 --tag test3 --gradient_check  &
##nohup python main_fedspa.py --dense_ratio 0.5 --gpu 0 --epochs 3 --tag test3   &
#nohup python main_fedspa.py --dense_ratio 0.2  --epochs 3 --tag test3  --gradient_check  &
##nohup python main_fedspa.py --dense_ratio 0.2 --gpu 1 --epochs 3 -- test3   &
#nohup python main_fedspa.py --dense_ratio 0.1 --gpu 1 --epochs 3 --tag test3 --gradient_check &
##python main_fedspa.py --dense_ratio 0.1 --gpu 1 --epochs 3 --tag test3 --comm_round 2000
wandb offline
cd ../../../standalone/ditto
CUDA_VISIBLE_DEVICES=0  nohup python main_ditto.py  --dataset emnist --model lenet5 --partition_method homo --tag test10 --comm_round 400  --seed 1 >m1.out 2>&1 &
CUDA_VISIBLE_DEVICES=0  nohup python main_ditto.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.2 --comm_round 400 --seed 1 >m2.out 2>&1 &
CUDA_VISIBLE_DEVICES=0  nohup python main_ditto.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.1 --comm_round 400  --seed 1  >m3.out  2>&1 &

CUDA_VISIBLE_DEVICES=0  nohup python main_ditto.py  --dataset emnist --model lenet5 --partition_method homo --tag test10 --comm_round 400  --seed 2 >m1.out 2>&1 &
CUDA_VISIBLE_DEVICES=0  nohup python main_ditto.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.2 --comm_round 400 --seed 2 >m2.out 2>&1 &
CUDA_VISIBLE_DEVICES=7  nohup python main_ditto.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.1 --comm_round 400  --seed 2  >m3.out  2>&1 &

cd ../fedavg
CUDA_VISIBLE_DEVICES=1 nohup python main_fedavg.py  --dataset emnist --model lenet5 --partition_method homo --tag test10 --comm_round 400   --seed 1 >m1.out 2>&1  &
CUDA_VISIBLE_DEVICES=1 nohup python main_fedavg.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.2 --comm_round 400 --seed 1 >m2.out 2>&1 &
CUDA_VISIBLE_DEVICES=1 nohup python main_fedavg.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.1 --comm_round 400  --seed 1  >m3.out 2>&1 &
CUDA_VISIBLE_DEVICES=1 nohup python main_fedavg.py  --dataset emnist --model lenet5 --partition_method homo --tag test10 --comm_round 400   --seed 2 >m1.out 2>&1  &
CUDA_VISIBLE_DEVICES=1 nohup python main_fedavg.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.2 --comm_round 400 --seed 2 >m2.out 2>&1 &
CUDA_VISIBLE_DEVICES=7 nohup python main_fedavg.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.1 --comm_round 400  --seed 2  >m3.out 2>&1 &

cd ../fedslim
CUDA_VISIBLE_DEVICES=2 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method homo --dense_ratio 0.5  --comm_round 400  --strict_avg  --seed 1 >m1.out 2>&1 &
CUDA_VISIBLE_DEVICES=2 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method hetero --dense_ratio 0.5   --comm_round 400  --partition_alpha 0.2 --strict_avg --seed 1 >m2.out 2>&1 &
CUDA_VISIBLE_DEVICES=2 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method hetero --dense_ratio 0.5   --comm_round 400  --partition_alpha 0.1 --strict_avg --seed 1  >m3.out 2>&1 &
CUDA_VISIBLE_DEVICES=2 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method homo --dense_ratio 0.5  --comm_round 400  --strict_avg  --seed 2 >m1.out 2>&1 &
CUDA_VISIBLE_DEVICES=2 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method hetero --dense_ratio 0.5   --comm_round 400  --partition_alpha 0.2 --strict_avg --seed 2  >m2.out 2>&1 &
CUDA_VISIBLE_DEVICES=6 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method hetero --dense_ratio 0.5   --comm_round 400  --partition_alpha 0.1 --strict_avg  --seed 2  >m3.out 2>&1 &

cd ../fedslim
CUDA_VISIBLE_DEVICES=3 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method homo --dense_ratio 0.5  --static --comm_round 400  --strict_avg  --seed 1 >m1.out 2>&1 &
#nohup python main_fedspa.py  --tag test8  --partition_method homo --dense_ratio 0.5   &
CUDA_VISIBLE_DEVICES=3 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method hetero --dense_ratio 0.5   --static --comm_round 400  --partition_alpha 0.2 --strict_avg --seed 1 >m2.out 2>&1 &
CUDA_VISIBLE_DEVICES=3 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method hetero --dense_ratio 0.5  --static --comm_round 400  --partition_alpha 0.1 --strict_avg --seed 1  >m3.out 2>&1 &

CUDA_VISIBLE_DEVICES=3 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method homo --dense_ratio 0.5  --static --comm_round 400  --strict_avg  --seed 2 >m1.out 2>&1 &
CUDA_VISIBLE_DEVICES=3 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method hetero --dense_ratio 0.5   --static --comm_round 400  --partition_alpha 0.2 --strict_avg --seed 2 >m2.out 2>&1 &
CUDA_VISIBLE_DEVICES=6 nohup python main_fedslim.py  --dataset emnist --model lenet5 --tag test10  --partition_method hetero --dense_ratio 0.5  --static --comm_round 400  --partition_alpha 0.1 --strict_avg --seed 2  >m3.out 2>&1 &

cd ../subavg
#nohup python main_fedspa.py --dense_ratio 0.5 --gpu 0 --epochs 3 --tag test5 --gradient_check &
CUDA_VISIBLE_DEVICES=4 nohup python main_subavg.py  --dataset emnist --model lenet5 --dense_ratio 0.5 --tag test10  --partition_method homo --comm_round 400 --seed 1   >m1.out 2>&1 &
CUDA_VISIBLE_DEVICES=4 nohup python main_subavg.py  --dataset emnist --model lenet5 --dense_ratio 0.5 --tag test10  --partition_method hetero --comm_round 400 --partition_alpha 0.2  --seed 1 >m2.out 2>&1 &
CUDA_VISIBLE_DEVICES=4 nohup python main_subavg.py  --dataset emnist --model lenet5 --dense_ratio 0.5 --tag test10  --partition_method hetero --comm_round 400 --partition_alpha 0.1  --seed 1 >m3.out 2>&1 &
CUDA_VISIBLE_DEVICES=4 nohup python main_subavg.py  --dataset emnist --model lenet5 --dense_ratio 0.5 --tag test10  --partition_method homo --comm_round 400 --seed 2   >m1.out 2>&1 &
CUDA_VISIBLE_DEVICES=4 nohup python main_subavg.py  --dataset emnist --model lenet5 --dense_ratio 0.5 --tag test10  --partition_method hetero --comm_round 400 --partition_alpha 0.2  --seed 2 >m2.out 2>&1 &
CUDA_VISIBLE_DEVICES=6 nohup python main_subavg.py  --dataset emnist --model lenet5 --dense_ratio 0.5 --tag test10  --partition_method hetero --comm_round 400 --partition_alpha 0.1  --seed 2 >m3.out 2>&1 &

cd ../local
CUDA_VISIBLE_DEVICES=5 nohup python main_local.py  --dataset emnist --model lenet5 --partition_method homo --tag test10 --comm_round 400 --seed 1  >m1.out  2>&1 &
CUDA_VISIBLE_DEVICES=5 nohup python main_local.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.2 --comm_round 400  --seed 1 >m2.out  2>&1 &
CUDA_VISIBLE_DEVICES=5 nohup python main_local.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.1 --comm_round 400  --seed 1  >m3.out 2>&1 &
CUDA_VISIBLE_DEVICES=5 nohup python main_local.py  --dataset emnist --model lenet5 --partition_method homo --tag test10 --comm_round 400 --seed 2  >m1.out  2>&1 &
CUDA_VISIBLE_DEVICES=5 nohup python main_local.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.2 --comm_round 400  --seed 2 >m2.out  2>&1 &
CUDA_VISIBLE_DEVICES=6 nohup python main_local.py  --dataset emnist --model lenet5 --partition_method hetero --tag test10  --partition_alpha 0.1 --comm_round 400  --seed 2  >m3.out 2>&1 &

wait

#python main_fedspa.py --dense_ratio 0.1 --gpu 0 --epochs 3 --tag test5 --gradient_check --comm_round  1500
