import argparse

def get_arg_parser():
    parser = argparse.ArgumentParser(description='arguments')
    parser.add_argument('--model', type=str, help='The model to run.')
    parser.add_argument('--config', type=str, help='The config files.')
    parser.add_argument('--mode', type=str, default='train',help='Train, Both Fix, Single Fix')

    parser.add_argument('--name', type=str, help='Name of the experiment ')
    parser.add_argument('--gpu', type=int, default=0, help='GPU card to use')

    parser.add_argument('--new_data', action='store_true' ,help='use new data')
    parser.add_argument('--task', type=str, default='mortality',help='phenotype or mortality')
    parser.add_argument('--fold', type=int, default=1, choices=[1, 2, 3, 4, 5])
    parser.add_argument('--ehr_root', type=str, help='Path to the data dir',
                        default='/root/autodl-tmp/datasets/data')
    parser.add_argument('--resized_cxr_root', type=str, help='Path to the cxr data',
                        default='/root/autodl-tmp/datasets/mimic_cxr_resized')
    parser.add_argument('--cxr_root', type=str, help='Path to the cxr data',
                        default='/hdd/datasets/mimic-cxr-jpg/2.0.0/files')
    parser.add_argument('--batch_size', type=int, default=16)
    parser.add_argument('--num_workers', type=int, default=4)
    parser.add_argument('--best_model_path', type=str)
    parser.add_argument('--hidden_size', type=int, default=256)
    parser.add_argument('--ehr_n_head', type=int, default=4)
    parser.add_argument('--ehr_n_layers', type=int, default=1)
    parser.add_argument('--ehr_dropout', type=float, default=0.2)

    parser.add_argument('--matched',action='store_true')
    parser.add_argument('--simple_three',action='store_true')
    parser.add_argument('--pcgrad',action='store_true')

    parser.add_argument('--timestep', type=float, default=1.0, help="fixed timestep used in the dataset")

    parser.add_argument('--fix_adc_lambda', action='store_false', dest='adaptive_adc_lambda',
                        help='Use zero value for lambda in ADC instead of adpative values.')
    parser.add_argument('--gamma', type=float, default=0.75,
                        help='weighting of GRL and CosSim for shared representation alignment')

    parser.add_argument('--aug_missing_ratio', type=float, default=0.3,
                        help='Ratio of masked modality during training when using paired training set.')

    parser.add_argument('--lr', type=float, default=0.0001, help='learning rate')
    parser.add_argument('--ehrlr', type=float, default=0.0001, help='learning rate')
    parser.add_argument('--cxrlr', type=float, default=0.0001, help='learning rate')
    parser.add_argument('--wd', type=float, default=0.0, help='weight decay')

    parser.add_argument('--epochs', type=int, default=250, help='number of epochs to train')
    parser.add_argument('--patience', type=int, default=10, help='number of epoch to wait for best')
    parser.add_argument('--lr_decay_step',type=int,default=10)
    parser.add_argument('--lr_decay_ratio',type=float,default=0.1)
    parser.add_argument('--noisy', type=lambda x: x.lower() == 'true', default=False, help='the noisy add to gradient')
    parser.add_argument('--cml',type=bool,default=False,help='cml three modalities directly')
    parser.add_argument('--ogm_alpha',type=float,default=0.5,help='OGM alpha')
    parser.add_argument('--ogm_start',type=int,default=0,help='OGM statrs epoch')
    parser.add_argument('--ogm_end',type=int,default=200,help='OGM ends epoch')
    parser.add_argument('--grad_penalty',type=bool,default=False,help='Gradient gap penalty')
    parser.add_argument('--method', type=str, default='None')
    parser.add_argument('--fusion_method',type=str, default='concate')
    parser.add_argument('--index',type=int, default=None)
    parser.add_argument('--seed',type=int, default=42)
    parser.add_argument('--gs_flag',action='store_true')
    parser.add_argument('--dynamic',action='store_true')
    parser.add_argument('--sam',action='store_true')
    parser.add_argument('--sam_on',action='store_true')
    parser.add_argument('--simple',action='store_true')
    parser.add_argument('--single',action='store_true')
    parser.add_argument('--OGMGE',action = 'store_true',help='OGM')
    parser.add_argument('--qmf',action = 'store_true',help='QMF')
    parser.add_argument('--mmpareto',action = 'store_true',help='mmpareto')
    parser.add_argument('--bf_best_model_path',type=str,help='load the best model for jointing learning or single model learning',default='/home/Project_Drfuse/Drfuse/forMLAfull/phenotype/best_model/Simple-mla-bs16-lr0.0001-fusionconcate-hs256-eh4-el1-ed0.2-av_alpha0.8-fix-seed2024/checkpoints/epoch=14-overall/PRAUC=0.43.ckpt')
    parser.add_argument('--fix',action = 'store_true',help='fix encoder ehr and train mlp')
    parser.add_argument('--fix_modality',type = str,help='Select one modaliy encoder to embed')
    parser.add_argument('--av_alpha',type = float, default = 0.55, help='factor for tow modalities fusion, ehr*alpha + (1-alpha)*cxr')
    parser.add_argument('--mmpareto_gamma',type = float, default = 1.5, help='MMpareto')
    parser.add_argument('--mlp',action = 'store_true',help='draw mlp gradient image')
    parser.add_argument('--agm',action = 'store_true',help='agm method')
    parser.add_argument('--mortality2',action = 'store_true',help='softmax mortality')
    parser.add_argument('--iteralabels',action = 'store_true',help='interactively train each label')
    parser.add_argument('--score_method', type=str, default='simple',help='simple focal')
    parser.add_argument('--agm_alpha', type=float, default=0.25, help='agm alpha')
    parser.add_argument('--gblend', action = 'store_true',help='gblend')
    parser.add_argument('--sagm', action = 'store_true',help='sagm')

    parser.add_argument('--ehrr',type=float,default=0.5)
    parser.add_argument('--cxrr',type=float,default=0.5)
    parser.add_argument('--fusionr',type=float,default=0.5)
    parser.add_argument('--sagm_alpha',type=float,default=0.5)
    parser.add_argument('--rho',type=float,default=0.3)
    parser.add_argument('--scale_alpha',type=float,default=0.01)
    parser.add_argument('--uniloss',action = 'store_true',help='uniloss')
    parser.add_argument('--test_sam',action = 'store_true',help='test sam')

    parser.add_argument('--draw',action = 'store_true',help='draw sam image')
    parser.add_argument('--no_checkpoint', action='store_false', dest='save_checkpoint')
    parser.add_argument('--save_checkpoint', action='store_true', default=True, help='Save model checkpoint')
    parser.add_argument('--dev_run', action='store_true')


  

    parser.add_argument('--save', action='store_true', default=False, help='Save representation')
    parser.add_argument('--model_name', type=str, default='', help='Model name')


    parser.add_argument('--save_trace', action='store_true', default=False, help='Save trace')
    parser.add_argument('--save_eigenvalue', action='store_true', default=False, help='Save eigenvalue')
    parser.add_argument('--save_trace_epoch', action='store_true', default=False, help='Save trace epoch')

    parser.add_argument('--sam_decomp', action='store_true', default=False, help='SAM-Decomp')
    parser.add_argument('--score_weight', type=float, default=0.5, help='Score weight')
    parser.add_argument('--momentum', type=float, default=0.9, help='Momentum')
    parser.add_argument('--dynamic_mode', action='store_true', help='dynamic mode')
    parser.add_argument('--loss_multi', type=float, default=1.0, help='Loss multi')
    parser.add_argument('--loss_ehr', type=float, default=1.0, help='Loss ehr')
    parser.add_argument('--loss_cxr', type=float, default=1.0, help='Loss cxr')
    return parser
