<div align="center">

# FOCA

</div>

## Description

Official FOCA codebase based on the [Lightning Hydra Template](https://github.com/ashleve/lightning-hydra-template)

## How to run

Install dependencies

```bash
# Download repository as supplementary material

# [OPTIONAL] create conda environment
conda create -n myenv python=3.9
conda activate myenv

# install pytorch according to instructions
# https://pytorch.org/get-started/

# install requirements
pip install -r requirements.txt
```
## Example: run FOCA on the Lotka-Volterra dataset

```bash
python run.py experiment=lv/foca
```

Available experiments (under [configs/experiment/](configs/experiment/)):
- `poly`: polynomial regression
- `ms`: mass-spring system
- `lv`: Lotka-Volterra ODEs
- `go`: glicolitic oscillator
- `ns`: Navier-Stokes equations
- `train_ablation`: ablation experiments 
 

## Other useful information
Train model with default configuration

```bash
# train on CPU
python run.py trainer=cpu

# train on GPU
python run.py trainer=gpu
```
> Note: alternatively, use the `run.py` script to run the training or evaluation with additional Rich printing.

Train model with chosen experiment configuration from [configs/experiment/](configs/experiment/)

```bash
python run.py experiment=experiment_name.yaml
```

You can override any parameter from command line like this

```bash
python run.py trainer.max_epochs=20 datamodule.batch_size=64
```
