This folder contains the code for the experiments in the paper "Local Convergence Analysis of Gradient Descent Ascent with Finite TImescale Separation" by Tanner Fiez and Lillian Ratliff.

The Experiments directory contains the code. The notebooks directory contains Jupyter Notebooks that run the majority of the experiments in the paper. The utils folder contains a file with a function that computes the quantity tau* from the paper given a Jacobian matrix. 

The GAN experiments with image datasets in the paper run the code from https://github.com/LMescheder/GAN_stability with minor adjustments for our purposes. The evaluation is done using the FID score code from https://github.com/mseitzer/pytorch-fid. We thank and acknowledge the implementations to those authors. We essentially only changed the https://github.com/LMescheder/GAN_stability by changing the learning rates, keeping multiple exponential averages at once, and making the updates simultaneous. For ease of reproducibility, we have included our version of the cloned repo. This code can be found in the GAN folder.

For the GAN experiments, the data would need to be downloaded for CIFAR-10 and CelebA and put in the data folder inside the GAN folder. Then, the run_gans.sh should run the experiments we ran. Note that the experiments do take probably a couple weeks to run in full for all of the runs. The results will be stored in the output folder. The code for evaluation is in the Evaluation folder inside the GAN folder. We provide the latent data used to generate images for the FID score. The generate_evaluation_data.py creates the real data for the FID score. Then, you need to input the names of the folders from the output folder with the saved checkpoints into the file evaluation.py. This file can then be ran to generate the FID scores along the learning path. The file evaluation.ipynb then made the plots of the FID scores in the paper.

Finally the folder MoG contains the code for the mixture of Gaussian experiments. The main file is MoG_Sim_ICLR.py and we ran the experiments by calling the shell files in the directory to simulate the parameters and seeds. The data is saved when it is ran into folders which we then made the plots using the notebook get_results-final.ipynb. 

The finiteratio.yaml provides the conda environment used for this work. 

If you have any questions, feel free to reach out to Tanner with an email to fiezt@uw.edu. Thanks!

