import pandas as pd
def process_re78_column(file_path, output_path=None):

    df = pd.read_csv(file_path)
    
    df['RE78'] = df['RE78'].apply(lambda x: 1 if x != 0 else 0)
    
    if file_path:
        df.to_csv(file_path, index=False)
    
    return df


def modify_and_reorder_columns(file_path, output_path=None):

    df = pd.read_csv(file_path)

    df.rename(columns={
        'T': 'treatment',
        'RE78': 'y_factual'
    }, inplace=True)

    df['y_counterfactual'] = -100
    df['y_0'] = df.apply(lambda row: row['y_factual'] if row['treatment'] == 0 else -100, axis=1)
    df['y_1'] = df.apply(lambda row: row['y_factual'] if row['treatment'] == 1 else -100, axis=1)

    feature_cols = [col for col in df.columns if col not in ['treatment', 'y_factual', 'y_counterfactual', 'y_0', 'y_1']]
    final_order = ['treatment', 'y_factual', 'y_counterfactual', 'y_0', 'y_1'] + feature_cols
    df = df[final_order]

    if output_path:
        df.to_csv(output_path, index=False)

    return df


df = modify_and_reorder_columns("./randomized.csv", "./randomized.csv")
