function FIG3_DATA_GENERATION_ODE

clear all   % clear all previous workspace information

options = odeset('RelTol',1e-5,'AbsTol',1e-5);  % error tolerances of the solution.

SS_NR = zeros(100,100);  % data storage initializing for speed up
SS_NE = zeros(100,100);
SS_NRE = zeros(100,100);

binary_NR = ones(100,100);
ANALYTICAL_NR = zeros(100,100);

PARAM_U = zeros(100,100);

TOTAL_X2 = zeros(100,100);
TOTAL_X1 = zeros(100,100);

DELTA = zeros(100,100);
R_free = zeros(100,100);

y = zeros(100,100);

w = [0.5 1 1]; % change to observe shift

gamma = 10;

count = 1;
for i = 1:100
    x1 = 0.01 * i;
    for j = 1:100
        disp(count) % display the number of ongoing execution
        count = count + 1;

        SP0 = zeros(1,3);  % concentration initialzation
        
        x2 = 0.01 * j;

        TOTAL_X1(i,j) = x1;
        TOTAL_X2(i,j) = x2;

        y(i,j) = (-(w(2)/w(3))*TOTAL_X1(i,j)) + (w(1)/w(3));

        k_on_NR = w(2)*x1 + w(3)*x2;  % value of u

        k_on_NE = w(1);     % value of v

        k_off_NR = 0.005;
        k_off_NE = 0.005;

        k_on_NR_E = k_on_NE*gamma;
        k_on_NE_R = k_on_NR*gamma;

        k_off_NR_E = k_off_NE*1;
        k_off_NE_R = k_off_NR*1;

        n = 6;
        R_TOT = 7.85;
        E_TOT = 5;

        delta = 1;

        K = 0.05;

        PARAM_U(i,j)= k_on_NR;

        parameterValues = [k_on_NR k_off_NR k_on_NE k_off_NE k_on_NR_E k_off_NR_E k_on_NE_R k_off_NE_R delta R_TOT E_TOT n gamma K];

        [t,SP] = ode15s(@(t,SP) odeequations(t,SP, parameterValues),[0 3600*24],SP0,options);

        last_point = length(t);

        SS_NR(i,j) = SP(last_point,1);
        SS_NE(i,j) = SP(last_point,2);
        SS_NRE(i,j) = SP(last_point,3);

        N = 1;
        R_free(i,j) = R_TOT - (SS_NR(i,j) + SS_NRE(i,j));
        r = R_free(i,j) / E_TOT;
        f = K^n / (K^n + SS_NE(i,j)^n);
        DELTA(i,j) = ((K^n + SS_NE(i,j)^n)*N) / ((K^n*r*N) + (K^n + SS_NE(i,j)^n)*gamma*r*SS_NE(i,j));

        p_term = (f*k_on_NR*N*r) + (gamma*r*k_on_NR*SS_NE(i,j));
        n_term = k_on_NE*N;
        d_term = gamma*k_on_NE;
        
        ANALYTICAL_NR(i,j) = ((p_term - n_term) / d_term); 

        if (k_on_NR < DELTA(i,j)*k_on_NE)
            ANALYTICAL_NR(i,j) = 0;
            binary_NR(i,j) = 0;
        end
    end
end

% save data file naming according to weights, load file in
% MEM_DECISION_BOUNDARY_PLOT.m to see surface plot
save('MEM_PPN_R_CONSERVED_0.5_1_1.mat');
end


%%%%%%%%%%% ODE MODEL %%%%%%%%%%%%
function [dSP] = odeequations(t,SP, parameterValues)

k_on_NR_base = parameterValues(1);
k_off_NR = parameterValues(2);

k_on_NE = parameterValues(3);
k_off_NE = parameterValues(4);

k_on_NR_E = parameterValues(5);
k_off_NR_E = parameterValues(6);

k_on_NE_R = parameterValues(7);
k_off_NE_R = parameterValues(8);

delta = parameterValues(9);

R_TOT = parameterValues(10);
E_TOT = parameterValues(11);

hill_coeff = parameterValues(12);

K = parameterValues(14);

N = 1;
%E = 0.1;

NR = SP(1);
NE = SP(2);
NRE = SP(3);

k_on_NR = k_on_NR_base*((K^(hill_coeff)/(K^(hill_coeff) + NE^(hill_coeff))));

%k_on_NR = k_on_NR_base;

R = R_TOT - (NR + NRE);
E = E_TOT;

dSP(1) = k_on_NR*N*R + k_off_NR_E*NRE - k_off_NR*NR- k_on_NR_E*NR*E-delta*NR;
dSP(2) = k_on_NE*N*E + k_off_NE_R*NRE - k_off_NE*NE- k_on_NE_R*NE*R- delta*NE;
dSP(3) = k_on_NR_E*NR*E + k_on_NE_R*NE*R - k_off_NE_R*NRE - k_off_NR_E*NRE - delta*NRE;


dSP = dSP';  % We are taking the transpose of dy
end