
clear all
tic

% Keeping all parameters and the perturbation natures same, only the
% conservation conditions were varied on the species R_tot and E_tot in
% the function " CHEM_PERCEPTRON_ODE " and the respective adaptation times
% recorded
% For each model, refer to "CHEM_PERCEPTRON_ODE"

% adaptTime function is used to check for Nan values while interpolating 90% 
% of initial steady state concentration and then the time required to return to 
% 90% steady state concentration from the perturbed steady state is
% calculated

species_0 = [0 0 0 0];
tspan1 = linspace(0, 3600.00*12, 600);
tspan_E1 = linspace(3600.00*12, 4800*12,600);
tspan2 = linspace(4800*12, 8400*12 ,600);
tspan_E2 = linspace(8400*12,10000*12,600);
tspan3 = linspace(10000*12,13600*12,600);
tspan_E3 = linspace(13600*12, 14800*12, 600);
tspan4 = linspace(14800*12,18400*12,600);



%Parameters to pass In the ODE: reaction rates, R_tot,E_tot
param = zeros(27648,9);
r = 1;
n_p = 1;
for a = 1:3
    nr_p = 1;  % value of u
    for i = 1:4
        nr_d = 1;
        for j = 1:2
            ne_p = 1;
            for k = 1:4
                ne_d = 1;
                for l = 1:2
                    nre_p = 1;
                    for m = 1:4
                        nre_d = 1;
                        for n = 1:3
                            nre_1p = 1;
                            for o = 1:4
                                nre_1d = 1;
                                for p = 1:3
                                    param(r,1) = 0.005*n_p;
                                    param(r,2) = 0.05*nr_p; %value of u
                                    param(r,3) = 0.005*nr_d;
                                    param(r,4) = 0.05*ne_p;    %value of v
                                    param(r,5) = 0.005*ne_d;
                                    param(r,6) = 5*nre_p;
                                    param(r,7) = 0.005*nre_d;
                                    param(r,8) = 5*nre_1p;
                                    param(r,9) = 0.005*nre_1d;
                                    r = r + 1;
                                    nre_1d = nre_1d*10;
                                end
                                nre_1p = nre_1p*10;
                            end
                            nre_d = nre_d*10;
                        end
                        nre_p = nre_p*10;
                    end
                    ne_d = ne_d*10;
                end
                ne_p = ne_p*10;
            end
            nr_d = nr_d*10;
        end
        nr_p = nr_p*10;
    end
    n_p = n_p*10;
end

n_d = 0.05;
w = 0.05;
R_tot = 50;
E_tot = 5;

% Time to regain 90% steady state concentration for each model:

t_90 = zeros(27648,3); % Both R_tot and E_tot conserved
% t_90_no_cons = zeros(27648,3) --> no conservation
% t_90_E = zeros(27648,3) --> E_tot conserved only
% t_90_R = zeros(27648,3) --> R_tot conserved only

    c = 1;
for i = 1:27648

    %initial run
    arg_pass = [param(i,1) n_d param(i,2) param(i,3) param(i,4) param(i,5) param(i,6) param(i,7) param(i,8) param(i,9) w R_tot E_tot];
    [t ,species] = ode15s(@(t,species) CHEM_PERCEPTRON_ODE(t,species,arg_pass), tspan1, species_0 );

    % Event type 1: Equal Width pulse
    N = species(599,1);
    NR = species(599,2);
    NE = species(599,3);
    NRE = species(599,4);
    
    Ev1_Init_con = [N NR NE NRE];


    param(i,1) = param(i,1)*2;
    arg_pass1 = [param(i,1) n_d param(i,2) param(i,3) param(i,4) param(i,5) param(i,6) param(i,7) param(i,8) param(i,9) w R_tot E_tot];
    
    [t_e1 ,species_e1] = ode15s(@(t_e1,species_e1) CHEM_PERCEPTRON_ODE(t_e1,species_e1,arg_pass1), tspan_E1, Ev1_Init_con);
    
    % SS after Event 1
    param(i,1) = param(i,1)/2;

    SS_N_1 = species_e1(599,1);
    SS_NR_1 = species_e1(599,2);
    SS_NE_1 = species_e1(599,3);
    SS_NRE_1 = species_e1(599,4);

    SS1_Init_con = [SS_N_1 SS_NR_1 SS_NE_1 SS_NRE_1];
    arg_pass2 = [param(i,1) n_d param(i,2) param(i,3) param(i,4) param(i,5) param(i,6) param(i,7) param(i,8) param(i,9) w R_tot E_tot];
    [t_ss1, species_ss1] = ode15s(@(t_ss1,species_ss1) CHEM_PERCEPTRON_ODE(t_ss1,species_ss1,arg_pass2), tspan2, SS1_Init_con);
    
    % time interpolation for 90% concentration of the steady state value
    t_90(i,1)= AdaptTime(t_ss1, species_ss1, 3600*12) ;
    % t_90_no_cons(i,1) = AdaptTime(t_ss1, species_ss1, 3600*12) ;
    % t_90_E(i,1) = AdaptTime(t_ss1, species_ss1, 3600*12) ;
    % t_90_R(i,1) = AdaptTime(t_ss1, species_ss1, 3600*12) ;
   
    % Event type 2: Different width
    
    param(i,1) = param(i,1)*2;

    N1 = species_ss1(599,1);
    NR1 = species_ss1(599,2);
    NE1 = species_ss1(599,3);
    NRE1 = species_ss1(599,4);

    Ev2_Init_con = [N1 NR1 NE1 NRE1];
    arg_pass3 = [param(i,1) n_d param(i,2) param(i,3) param(i,4) param(i,5) param(i,6) param(i,7) param(i,8) param(i,9) w R_tot E_tot];
    
    [t_e2, species_e2] = ode15s(@(t_e2,species_e2) CHEM_PERCEPTRON_ODE(t_e2,species_e2,arg_pass3), tspan_E2, Ev2_Init_con);

    % SS after Event 2
    param(i,1) = param(i,1)/2;

    SS_N_2 = species_e2(599,1);
    SS_NR_2 = species_e2(599,2);
    SS_NE_2 = species_e2(599,3);
    SS_NRE_2 = species_e2(599,4);

    SS2_Init_con = [SS_N_2 SS_NR_2 SS_NE_2 SS_NRE_2];
    arg_pass4 = [param(i,1) n_d param(i,2) param(i,3) param(i,4) param(i,5) param(i,6) param(i,7) param(i,8) param(i,9) w R_tot E_tot];
    [t_ss2, species_ss2] = ode15s(@(t_ss2,species_ss2) CHEM_PERCEPTRON_ODE(t_ss2,species_ss2,arg_pass4), tspan3, SS2_Init_con);
    
    % time interpolation for 90% concentration of the steady state value
    t_90(i,2) = AdaptTime(t_ss2, species_ss2, 8400*12);
    % t_90_no_cons(i,2) = AdaptTime(t_ss2, species_ss2, 8400*12);
    % t_90_E(i,2) = AdaptTime(t_ss2, species_ss2, 8400*12);
    % t_90_R(i,2) = AdaptTime(t_ss2, species_ss2, 8400*12);
   

    % Event type 3: Different height with respect to event 1    
    param(i,7) = param(i,7)*1.5;
    N2 = species_ss2(599,1);
    NR2 = species_ss2(599,2);
    NE2 = species_ss2(599,3);
    NRE2 = species_ss2(599,4);

    Ev3_Init_con = [N2 NR2 NE2 NRE2];
    arg_pass5 = [param(i,1) n_d param(i,2) param(i,3) param(i,4) param(i,5) param(i,6) param(i,7) param(i,8) param(i,9) w R_tot E_tot];
    [t_e3, species_e3] = ode15s(@(t_e3,species_e3) CHEM_PERCEPTRON_ODE(t_e3,species_e3,arg_pass5), tspan_E3, Ev3_Init_con);

   % SS after event 3
   param(i,1) = param(i,1)/1.5;

    SS_N_3 = species_e3(599,1);
    SS_NR_3 = species_e3(599,2);
    SS_NE_3 = species_e3(599,3);
    SS_NRE_3 = species_e3(599,4);

    SS3_Init_con = [SS_N_3 SS_NR_3 SS_NE_3 SS_NRE_3];
    arg_pass6 = [param(i,1) n_d param(i,2) param(i,3) param(i,4) param(i,5) param(i,6) param(i,7) param(i,8) param(i,9) w R_tot E_tot];
    [t_ss3, species_ss3] = ode15s(@(t_ss3,species_ss3) CHEM_PERCEPTRON_ODE(t_ss3,species_ss3,arg_pass6), tspan4, SS3_Init_con);
    
    % time interpolation for 90% concentration of the steady state value
    t_90(i,3) = AdaptTime(t_ss3, species_ss3, 13600*12);
    % t_90_no_cons(i,3) = AdaptTime(t_ss3, species_ss3, 13600*12);
    % t_90_E(i,3) = AdaptTime(t_ss3, species_ss3, 13600*12);
    % t_90_R(i,3) = AdaptTime(t_ss3, species_ss3, 13600*12);
    
    c = c + 1
    
    
end


    sum = 0;
    counter = 0;
    

     l = length(t_90(:,1));
    for i = 1:l
        if(t_90(i,1) ~= 0)
            sum = sum + t_90(i,1);
            counter = counter + 1;
        end
       
    end

    %      l = length(t_90_no_cons(:,1));
    % for i = 1:l
    %     if(t_90_no_cons(i,1) ~= 0)
    %         sum = sum + t_90_no_cons(i,1);
    %         counter = counter + 1;
    %     end
    % 
    % end

    %      l = length(t_90_E(:,1));
    % for i = 1:l
    %     if(t_90_E(i,1) ~= 0)
    %         sum = sum + t_90_E(i,1);
    %         counter = counter + 1;
    %     end
    % 
    % end

    %      l = length(t_90_R(:,1));
    % for i = 1:l
    %     if(t_90_R(i,1) ~= 0)
    %         sum = sum + t_90_R(i,1);
    %         counter = counter + 1;
    %     end
    % 
    % end
    avg = sum/counter;
    fileName = 'both_cons.mat';
    % fileName = 'R_tot_cons.mat'; time variable : t_90_R
    % fileName = 'E_tot_cons.mat'; time variable : t_90_E
    % fileName = 'no_cons.mat';  time variable : t_90_no_cons

    save(fileName,'t_90'); % Respective time variable for each file
    toc


function [dydt] = CHEM_PERCEPTRON_ODE (t,species, arg_pass)
%# Kinetic rate constant for all the chemical interactions

k_1 = arg_pass(1); %For Null --> N, Unit: nM s^{-1}
k_1r = arg_pass(2); % For N --> Null, Unit:  s^{-1}
k_2 = arg_pass(3);% For N + R --> NR, Unit:  nM^{-1}s^{-1}
k_2r = arg_pass(4);% For NR --> N + R, Unit:  s^{-1}
k_3 = arg_pass(5); % For N + E --> NE
k_3r = arg_pass(6);% For NE --> N + E
k_4 = arg_pass(7); % For NR + E --> NRE
k_4r = arg_pass(8);  % For NRE--> NR + E
k_5 = arg_pass(9); %For NE + R --> NRE
k_5r = arg_pass(10); %For NRE--> NE + R
gamma = arg_pass(11); %self degradation rate of NR, NE and NRE

N = species(1);
NR = species(2);
NE = species(3);
NRE = species(4);

% Both conserved:
R_tot = arg_pass(12);
R = R_tot-NR-NRE;
E_tot  = arg_pass(13);
E = E_tot - NE - NRE;

% No conservation:
% R_tot = arg_pass(12);
% R = R_tot;
% E_tot  = arg_pass(13);
% E = E_tot;

% E_tot conserved:
% R_tot = arg_pass(12);
% R = R_tot;
% E_tot  = arg_pass(13);
% E = E_tot - NE - NRE;

% R_tot conserved:
% R_tot = arg_pass(12);
% R = R_tot-NR-NRE;
% E_tot  = arg_pass(13);
% E = E_tot;

dydt(1) = k_1 + k_2r*NR + k_3r*NE - k_2*N*R - k_3*N*E - k_1r*N;
dydt(2) = k_2*N*R + k_4r*NRE - k_4*NR*E-k_2r*NR - gamma*NR ;
dydt(3) = k_3*N*E + k_5r*NRE - k_5*NE*R-k_3r*NE - gamma*NE;
dydt(4) = k_4*NR*E + k_5*NE*R - k_4r*NRE - k_5r*NRE - gamma*NRE;

dydt = dydt';


end

function [t_90] = AdaptTime (t, ss, ev_end)
ss_90 = 1.1*ss(599,2);
test = zeros(1,5);
time = zeros(1,5);
    
    for a = 1:5
        test(1,a) = ss(a,2);
        time(1,a) = t(a,1);
    end
        intr = interp1(test, time,ss_90);
        x = isnan(intr);
            if(x == 0)
                t_90 = intr - ev_end;
            else 
                t_90 = 0;
            end

end












