function FIG1b

clear all   % clear all previous workspace information

options = odeset('RelTol',1e-5,'AbsTol',1e-5);  % error tolerances of the solution.

SS_NR = zeros(20,1);  % data storage initializing for speed up
SS_NE = zeros(20,1);
SS_NRE = zeros(20,1);

ANALYTICAL_NR = zeros(20,1);

DELTA = zeros(20,1);
R_free = zeros(20,1);

p_term = zeros(20,1);
n_term = zeros(20,1);

PARAM_U = zeros(20,1);

f = zeros(20,1);

gamma = 10;

n_vec = [4 8];

count = 1;
for j = 1:2
    for i = 1:20
        disp(count) % display the number of ongoing execution
        count = count + 1;

        SP0 = zeros(1,3);  % concentration initialzation

        n = n_vec(j);

        k_on_NR = 0.05 * i;  % value of u

        k_on_NE = 0.5;     % value of v

        k_off_NR = 0.005;
        k_off_NE = 0.005;

        k_on_NR_E = k_on_NE*gamma;
        k_on_NE_R = k_on_NR*gamma;

        k_off_NR_E = k_off_NE*1;
        k_off_NE_R = k_off_NR*1;

        R_TOT = 50;
        E_TOT = 25;

        delta = 1;

        K = 0.05;

        PARAM_U(i) = k_on_NR;

        parameterValues = [k_on_NR k_off_NR k_on_NE k_off_NE k_on_NR_E k_off_NR_E k_on_NE_R k_off_NE_R delta R_TOT E_TOT n gamma K];

        [t,SP] = ode15s(@(t,SP) odeequations(t,SP, parameterValues),[0 3600*24],SP0,options);

        last_point = length(t);

        SS_NR(i) = SP(last_point,1);
        SS_NE(i) = SP(last_point,2);
        SS_NRE(i) = SP(last_point,3);

        N = 1;
        R_free(i) = R_TOT - (SS_NR(i) + SS_NRE(i));
        r = R_free(i) / E_TOT;
        f(i) = K^n / (K^n + SS_NE(i)^n);
        DELTA(i) = ((K^n + SS_NE(i)^n)*N) / ((K^n*r*N) + (K^n + SS_NE(i)^n)*gamma*r*SS_NE(i));

        p_term(i) = f(i)*k_on_NR*N*r + gamma*r*k_on_NR*SS_NE(i);
        n_term(i) = k_on_NE*N;

        ANALYTICAL_NR(i) = ((f(i)*k_on_NR*N*r - k_on_NE*N + gamma*r*k_on_NR*SS_NE(i)) / (gamma*k_on_NE));

        if (k_on_NR < DELTA(i)*k_on_NE)
            ANALYTICAL_NR(i) = 0;
        end
    end
    figure(1)
    plot(PARAM_U,SS_NR,LineWidth=8,Color=[0.6 0.6 0.6]);
    hold on
    plot(PARAM_U,ANALYTICAL_NR,LineStyle="none",Marker=".",MarkerSize=30);
    hold on
    legend('Simulated','Analytical',location='northwest',fontsize=24,box='off')
    set(gca,fontsize=24)
    axis square
end

save('MEM_R_CONSERVED.mat');
end

%%%%%%%%%%% ODE MODEL %%%%%%%%%%%%
function [dSP] = odeequations(t,SP, parameterValues)

k_on_NR_base = parameterValues(1);
k_off_NR = parameterValues(2);

k_on_NE = parameterValues(3);
k_off_NE = parameterValues(4);

k_on_NR_E = parameterValues(5);
k_off_NR_E = parameterValues(6);

k_on_NE_R = parameterValues(7);
k_off_NE_R = parameterValues(8);

delta = parameterValues(9);

R_TOT = parameterValues(10);
E_TOT = parameterValues(11);

hill_coeff = parameterValues(12);

K = parameterValues(14);

N = 1;

NR = SP(1);
NE = SP(2);
NRE = SP(3);

k_on_NR = k_on_NR_base*((K^(hill_coeff)/(K^(hill_coeff) + NE^(hill_coeff))));

R = R_TOT - (NR + NRE);
E = E_TOT;

dSP(1) = k_on_NR*N*R + k_off_NR_E*NRE - k_off_NR*NR- k_on_NR_E*NR*E-delta*NR;
dSP(2) = k_on_NE*N*E + k_off_NE_R*NRE - k_off_NE*NE- k_on_NE_R*NE*R- delta*NE;
dSP(3) = k_on_NR_E*NR*E + k_on_NE_R*NE*R - k_off_NE_R*NRE - k_off_NR_E*NRE - delta*NRE;


dSP = dSP';  % We are taking the transpose of dy
end