# Two Heads are Better Than One: A Simple Exploration Framework for Efficient Multi-Agent Reinforcement Learning (NeurIPS 2023)

Based on PyMARL (https://github.com/oxwhirl/pymarl/). Please refer to that repo for more documentation.

This repo contains the cleaned-up code that was used in "Two Heads are Better Than One: A Simple Exploration Framework for Efficient Multi-Agent Reinforcement Learning".

## Included in this repo

We thank the authors of "QPLEX: Duplex Dueling Multi-Agent Q-Learning" (https://arxiv.org/abs/2008.01062) for their implementation of QPLEX (https://github.com/wjh720/QPLEX/), whose implementation we used. The exact implementation we used is included in this repo.


## For all SMAC experiments we used SC2.4.6.2.69232 (not SC2.4.10). The underlying dynamics are sufficiently different that you **cannot** compare runs across the 2 versions!
The `install_sc2.sh` script will install SC2.4.6.2.69232.

## Running experiments

The config files (`src/config/algs/*.yaml`) contain default hyper-parameters for the respective algorithms.


## Citing

Bibtex:
```
@inproceedings{li2023two,
  title={Two Heads are Better Than One: A Simple Exploration Framework for Efficient Multi-Agent Reinforcement Learning},
  author={Jiahui, Li and Kun, Kuang and Baoxiang, Wang and Xingchen, Li and Fei, Wu and Jun, Xiao and Long, Chen},
  booktitle={Advances in Neural Information Processing Systems},
  year={2023}
}
```
