import numpy as np
import matplotlib.pyplot as plt
import pandas as pd

import matplotlib.pylab as pylab
params = {'axes.labelsize': 32,
         'xtick.labelsize': 28,
         'ytick.labelsize': 28,
            'pdf.fonttype': 42,
          'ps.fonttype': 42}
pylab.rcParams.update(params)


input_files = ["pcaso15_25", "minimize_pcaso15_25"]
bench = "polybench"

if __name__ == '__main__':
    labels = ['Mejor solución (299 passes)', 'Mejor solución (141 passes)']
    tags = ['Mejor solución\n(299 passes)', 'Mejor solución\n(141 passes)']
    
    data_time = []
    
    df2 = pd.DataFrame()
    
    for i,x in enumerate(input_files):
        count = 0
        print(x)
        if "-O" in x:
            data_time.append(np.loadtxt(f'solutions_fitness_{x}.csv', delimiter=','))
        else:
            data_time.append(np.loadtxt(f'solutions_fitness_{x}.csv', delimiter=','))
        
        print(np.median(data_time[-1]))
        
        if i != 0:
            print((np.median(data_time[-1]) - np.median(data_time[0]))/np.median(data_time[0]) * 100)

            
        #data_process.append(np.loadtxt(f'size_measurements_firefox{x}_cdp.csv', delimiter=','))
        if "-O" in x:
            df2[x.replace('-','')] = data_time[-1]
        else:
            df2[tags[i].replace('Best solution (141 passes)', 'Best_reduce')] = data_time[-1]
            
            
    
    df2.to_csv("time_measurements_df.csv")
    #df3.to_csv("memory_measurements_df.csv")
    
    fig = plt.figure(figsize=(10, 6.5))
    
    
    plt.plot([i for i in range(1,len(input_files)+1)], np.median(np.array(data_time), axis=1), color='indianred', alpha=0.75, label="_no_legend")
    plt.plot([i for i in range(1,len(input_files)+1)], np.array(data_time).min(axis=1), color='k', linestyle='dashed', linewidth=0.75, alpha=0.75, label='Line of best fit: Runtime Versus Optimization flag')
    plt.plot([i for i in range(1,len(input_files)+1)], np.array(data_time).max(axis=1), color='k', linestyle='dashed', linewidth=0.75, alpha=0.75, label='_no_legend')
    plt.fill_between([i for i in range(1,len(input_files)+1)], np.array(data_time).min(axis=1), np.array(data_time).max(axis=1), color='mediumseagreen', alpha=0.25, label="Range of Min and Max Runtime per Optimization flag")
    bp = plt.boxplot(data_time, labels=tags, patch_artist=True)
    for patch in bp['boxes']:
        patch.set(facecolor='w')
    plt.ylabel("Tiempo de ejecución (s)")
    #fig.tight_layout(pad=1.5)
    plt.subplots_adjust(top=0.9, bottom=0.14, left=0.17, right=0.99)



plt.savefig("./esp_improvementbpPolybenchSequences.pdf", dpi=300)
    