#include <map>
#include <vector>
#include <set>
#include <iostream>
#include <algorithm>
#include <cstdint>
#include <cstdlib>
#include <array>
#include <string>
#include <utility>
#include <math.h>

using namespace std;

typedef struct {
	int64_t range;
	string ans;
} intpair;

typedef struct {
	char c;
	int limit;
	int count;
} limstruct;

static
pair<int, int>
get_digit_stats(int64_t x)
{
	int digit_count = 1;
	while (x >= 10) {
		digit_count++;
		x /= 10;
	}

	return make_pair(digit_count, (int)x);
}

static
bool
sort_val(const limstruct& a, const limstruct& b)
{
	if (a.limit == b.limit)
		return a.count > b.count;

	return (a.limit < b.limit);
}


static
string
calc_int_base(
	vector<intpair>& pairs
)
{
	map<char, int> limits;
	map<char, int> counts;

	for (auto& p : pairs) {
		auto ans = get_digit_stats(p.range);
		char sig_ans = p.ans[0];

		counts[sig_ans]++;

		// we only care if we're the same length as first digit
		if (ans.first != p.ans.length()) {
			if (limits.find(sig_ans) == limits.end())
				limits[sig_ans] = 9;
			continue;
		}

		auto it = limits.find(sig_ans);
		if (it == limits.end()) {
			limits[sig_ans] = ans.second;
		} else {
			if ((*it).second > ans.second)
				(*it).second = ans.second;
		}
	}

	vector<limstruct> sortlim;
	for (auto& m : limits) {
		limstruct l;
		l.c = m.first;
		l.limit = m.second;
		l.count = counts[l.c];
		sortlim.push_back(l);
	}
	sort(sortlim.begin(), sortlim.end(), sort_val);

	// and now find 0
	string s;
	bool found = false;
	for (auto& p : pairs) {
		if (p.ans.length() == 1)
			continue;

		for (int i = 1; i < p.ans.length(); i++) {
			if (limits.end() == limits.find(p.ans[i])) {
				s += p.ans[i];
				found = true;
				break;
			}
		}

		if (found)
			break;
	}

	for (auto& n : sortlim)
		s += n.c;

	return s;
}

int main()
{
	int t;
	cin >> t;

	for (int i = 0; i < t; i++) {
		vector<intpair> pairs;
		int u;

		cin >> u;
		int64_t upper_lim = (int64_t)powl(10, u) - 1;

		for (int j = 0; j < 10000; j++) {
			intpair p;

			cin >> p.range >> p.ans;
			if (p.range == -1)
				p.range = upper_lim;

			pairs.emplace_back(p);
		}

		cout << "Case #" << i + 1 << ": " << calc_int_base(pairs) << endl;
	}

	return 0;
}