#include <algorithm>
#include <array>
#include <cassert>
#include <cmath>
#include <cstdio>
#include <cstring>
#include <iomanip>
#include <iostream>
#include <iterator>
#include <map>
#include <memory>
#include <numeric>
#include <queue>
#include <set>
#include <stack>
#include <string>
#include <sstream>
#include <unordered_map>
#include <vector>


#define INF 4000000000000000000LL
#define MOD 1000000007
#define ALL(x) std::begin(x), std::end(x)


#define SIZE 10000


int U;

long long Q[SIZE];

std::string R[SIZE];

std::map<long long, std::vector<std::string>>map;


std::string solve_s(int t)
{

  for (auto& kv : map) {
    auto& a = kv.second;
    
    std::sort(ALL(a));

    kv.second.erase(std::unique(ALL(a)), std::end(a));
  }

  std::vector<std::pair<std::string, int>> pairs(SIZE);

  for (int i = 0; i < SIZE; i ++) {
    pairs[i].first = std::to_string(Q[i]);
    pairs[i].second = i;
  }

  std::sort(ALL(pairs));

  std::string S(10, '.');

  std::set<char> set;

  for (int i = 0; i < SIZE; i ++) {
    int ind = pairs[i].second;
    
    std::string q = std::to_string(Q[ind]);
    std::string r = R[ind];

    int size = q.size();

    if (size == 1)
      continue;

    if (r.size() != size)
      continue;

    int x = q[0] - '0';
    
    char c = r[0];

    if (size == 1) {
      S[x] = c;

      set.insert(c);
    }
    else {
      if (! set.count(c)) {
        S[x] = c;

        set.insert(c);
      }
    }
  }

  for (int i = 0; i < SIZE; i ++)
    for (const auto& c : R[i])
      if (set.count(c) == 0) {
        S[0] = c;

        return S;
      }

  assert(false);

  return "SMALL";
}

std::string solve_l(int t)
{
  std::map<int, int> stat;

  for (int i = 0; i < SIZE; i ++)
    stat[R[i].size()] ++;

  std::map<char, int> stat2;

  std::string S(10, '.');

  for (int i = 0; i < SIZE; i ++)
    stat2[R[i][0]] ++;

  std::vector<std::pair<int, char>> pairs;

  std::set<char> set;

  for (const auto& kv : stat2) {
    pairs.emplace_back(kv.second, kv.first);

    set.insert(kv.first);
  }

  std::sort(ALL(pairs));
  std::reverse(ALL(pairs));

  for (int i = 0, size = pairs.size(); i < size; i ++)
    S[i + 1] = pairs[i].second;

  for (int i = 0; i < SIZE; i ++)
    for (const auto& c : R[i])
      if (set.count(c) == 0) {
        S[0] = c;

        return S;
      }

  assert(false);

  return "LARGE";
}


std::string solve(int t)
{
  map.clear();

  std::cin >> U;

  for (int i = 0; i < SIZE; i ++) {
    std::cin >> Q[i] >> R[i];

    map[Q[i]].push_back(R[i]);
  }

  if (Q[0] != -1) {
    return solve_s(t);
  }
  else {
    return solve_l(t);
  }
}


int main(int argc, char** argv)
{
  std::cin.tie(0);
  std::ios_base::sync_with_stdio(0);

  std::cout << std::fixed << std::setprecision(6);
  std::cerr << std::fixed << std::setprecision(6);

  int T;

  std::cin >> T;

  for (int t = 1; t <= T; t ++) {
    std::string s = solve(t);
    
    std::cout << "Case #" << t << ": " << s << std::endl;
  }

  return 0;
}
