#include <cmath>
#include <fstream>
#include <iostream>
#include <list>
#include <map>
#include <set>
#include <vector>

int find_digit_num(uint64_t val) {
    int counter = 0;

    while (val != 0) {
        val = val / 10;
        counter++;
    }

    return counter;
}

int find_first_digit_num(uint64_t val) {
    while (val >= 10) {
        val = val / 10;
    }

    return val;
}

void find_alphabet(uint64_t t, uint64_t u, std::set<char> alphabet, std::map<uint64_t, std::list<std::string>>& num_map)
{
    std::map<char, std::pair<uint64_t, uint64_t>> real_alphabet;

    for (auto c : alphabet)
    {
        real_alphabet[c] = std::make_pair(0, 0);
    }

    for(auto& val : num_map)
    {
        for(auto& str : val.second)
        {
            int i = str.length();

            auto intval = val.first;

            if (i != find_digit_num(val.first))
            {
                continue;
            }

            auto debug_c = str.front();
            int v = find_first_digit_num(intval);

            if (real_alphabet[str.front()].second == 0 && v != 0)
            {
                real_alphabet[str.front()].second = v;
            }
            else
            {
                if (real_alphabet[str.front()].second > v)
                {
                    real_alphabet[str.front()].second = v;
                }
            }
        }
    }


    std::string result = "!!!!!!!!!!";

    for(auto& c : real_alphabet)
    {
        result[c.second.second] = c.first;
    }

    for(auto c : alphabet)
    {
        if (result.find(c) == std::string::npos)
        {
            result[0] = c;
            break;
        }
    }

    std::cout << "Case #" << t << ": " << result << std::endl;


//std::string real_alphabet = "!!!!!!!!!";
//    for (int i = 1; i <= 9; ++i) {
//        for(int k = 0; k < u; ++k) {
//            auto base = pow(10, k);
//            if (real_alphabet[i] == '!' && !num_map[base + i].empty()) {
//                auto &strlist = num_map[i];
//                for (auto &str : strlist) {
//
//                    if (str.length() != k + 1)
//                    {
//                        continue;
//                    }
//
//                    if (real_alphabet.find(str.back()) == std::string::npos) {
//                        real_alphabet[i] = str.back();
//                        break;
//                    }
//                }
//            } else {
//                break;
//            }
//
//            if (real_alphabet[i] != '!')
//            {
//                break;
//            }
//        }
//    }
//
//    for(auto c : alphabet)
//    {
//        if (real_alphabet.find(c) == std::string::npos)
//        {
//            real_alphabet[0] = c;
//            break;
//        }
//    }
//
//    if (real_alphabet.find('!') == std::string::npos)
//    {
//        std::cout << "Case #" << t << ": " << real_alphabet << std::endl;
//    }
}

int main() {

//    std::ifstream myfile;
//    myfile.open ("/home/myagkov/CLionProjects/googlejam2/input.txt");

    uint64_t T = 0;
    int64_t U = 0;
    int64_t Y = 0;
    std::string path;


    std::cin >> T;
//    myfile >> T;

    for (uint64_t t = 1; t <= T; ++t)
    {
        std::cin >> U;
//        myfile >> U;
        std::map<uint64_t, std::list<std::string>> num_map;
        std::set<char> alphabet;

        for(int64_t i = 0; i < 10000; ++i)
        {
            int64_t number;
            std::string encoded_number;

            std::cin >> number;
            std::cin >> encoded_number;

//            myfile >> number;
//            myfile >> encoded_number;


            auto& val = num_map[number];
            val.push_back(encoded_number);

            if (encoded_number == "-1")
            {
                continue;
            }

            if (alphabet.size() < 10) {
                for (auto c : encoded_number) {
                    alphabet.insert(c);
                }
            }
        }
        find_alphabet(t, U, alphabet, num_map);
    }
    return 0;
}
