#include <array>
#include <iostream>

uint16_t get_mask(int from, int to)
{
    uint16_t mask = ((1 << (to + 1)) - 1) & ~((1 << from) - 1);
    return mask;
}

int main()
{
    int T;
    std::cin >> T;

    for (int t = 1; t <= T; ++t)
    {
        std::array<uint16_t, 26> dist { };
        std::array<bool, 26> present { };

        for (int i = 0; i < 26; ++i)
            dist[i] = uint16_t(~0);

        int u;
        std::cin >> u;

        for (int i = 0; i < 10000; ++i)
        {
            std::string q, r;
            std::cin >> q >> r;

            if (q.size() == 1)
                dist[r[0] - 'A'] &= get_mask(1, (q[0] - '0'));

            if (q[0] == '-' || q.size() > r.size())
            {
                dist[r[0] - 'A'] &= get_mask(1, 9);
            }
            else
            {
                dist[r[0] - 'A'] &= get_mask(1, q[0] - '0');
            }

            for (char c : r)
            {
                present[c - 'A'] = true;
            }
        }

        std::string res = "----------";
        int i = 0;
        while (i < 26)
        {
            if ((dist[i] & (dist[i] - 1)) != 0)
            {
                ++i;
                continue;
            }

            for (int j = 0; j < 10; ++j)
            {
                if (dist[i] == (1 << j))
                {
                    dist[i] = uint16_t(~0);
                    present[i] = false;

                    res[j] = i + 'A';
                    for (int k = 0; k < 26; ++k)
                        dist[k] &= ~(1 << j);



                    i = 0;
                    break;
                }
            }
        }

        for (int i = 0; i < 10; ++i)
        {
            if (res[i] == '-')
            {
                for (int j = 0; j < 26; ++j)
                {
                    if (present[j])
                    {
                        res[i] = j + 'A';
                        present[j] = false;
                    }
                }
            }
        }

        std::cout << "Case #" << t << ": " << res << std::endl;
    }
}
