#include <iostream>
#include <vector>
#include <cmath>
#include <map>
#include <set>
#include <queue>
using namespace std;

int main () {
  const int nQuery = 1e4;
  const int alphabetCount = 'Z' - 'A' + 1;
  int T;
  cin >> T;

  for (int t = 1; t <= T; t++) {
    int U;
    cin >> U;
    string Q, R;
    vector<pair<string, string>> I(nQuery);
    vector<bool> allCandidates(alphabetCount, false);
    for (int q = 0; q < nQuery; q++) {
      cin >> Q >> R;
      I[q] = {Q, R};
      for (int i = 0; i < R.length(); i++) {
        allCandidates[R[i] - 'A'] = true;
      }
    }

    map<char, set<int>> candidates;
    for (int i = 0; i < allCandidates.size(); i++) {
      if (allCandidates[i]) {
        candidates['A' + i] = set<int>({0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
      }
    }

    for (int q = 0; q < I.size(); q++) {
      pair<string, string> x = I[q];
      Q = x.first;
      R = x.second;
      candidates[R[0]].erase(0);
      if (Q[0] != '-' && Q.length() == R.length()) {
        for (int j = Q[0] - '0' + 1; j < 10; j++) {
          candidates[R[0]].erase(j);
        }
      } else {
        // Nothing can be made
      }
    }

    vector<set<char>> numberCandidates(10);
    for (auto it = candidates.begin(); it != candidates.end(); it++) {
      // cout << it->first << ": ";
      for (auto pos = it->second.begin(); pos != it->second.end(); pos++) {
        // cout << *pos << " ";
        numberCandidates[*pos].insert(it->first);
      }
      // cout << endl;
    }

    typedef pair<int, int> nc;
    priority_queue<nc, vector<nc>, greater<nc>> pq;
    for (int i = 0; i < numberCandidates.size(); i++) {
      pq.push({numberCandidates[i].size(), i});
    }

    vector<char> mapping(10);
    while (!pq.empty())
    {
      nc top = pq.top();
      pq.pop();

      if (top.first == numberCandidates[top.second].size()) {
        char takeChar = *(numberCandidates[top.second].begin());
        mapping[top.second] = takeChar;
        for (int i = 0; i < numberCandidates.size(); i++) {
          if (i == top.second) continue;
          int beforeEraseSize = numberCandidates[i].size();
          numberCandidates[i].erase(takeChar);
          if (numberCandidates[i].size() != beforeEraseSize) {
            pq.push({numberCandidates[i].size(), i});
          }
        }
      }
    }

    cout << "Case #" << t << ": ";
    for (int i = 0; i < mapping.size(); i++) {
      cout << mapping[i];
    }
    cout << endl;
  }
  return 0;
}
