#include <algorithm>
#include <cstdint>
#include <cassert>
#include <cmath>
#include <cstdio>
#include <deque>
#include <iomanip>
#include <iostream>
#include <map>
#include <queue>
#include <set>
#include <stack>
#include <unordered_map>
#include <unordered_set>
#include <utility>
#include <vector>
#include <cfloat>

using namespace std;

using lint=int64_t;
using uint=uint32_t;
using ulint=uint64_t;

template<class T>
using vector2d=vector<vector<T>>;

template<class T>
bool UpdateMax(T &a, const T &b){
  if(a<b){
    a=b;
    return true;
  }else{
    return false;
  }
}

template<class T>
bool UpdateMin(T &a, const T &b){
  if(a>b){
    a=b;
    return true;
  }else{
    return false;
  }
}

template <class T>
void OutVec(const vector<T>& vec){
  for(int i = 0; i < vec.size() - 1; ++i){
    cout<<vec[i]<<" ";
  }
  cout<<vec.back()<<endl;
}

template <class T>
void OutVec2d(const vector2d<T>& vec){
  for(auto v:vec){
    OutVec(v);
  }
}

bool compare(const pair<char,lint>& a, const pair<char,lint>& b){
  return a.second>b.second;
}

string Solve(){
  int u;
  cin>>u;
  int size=10000;
  string result(10,0);
  vector<string> input;
  vector<string> output;
  bool test3=false;
  for(int i=0;i<size;i++){
    string in,out;
    cin>>in>>out;

    if(in=="-1"){
      test3=true;
    }
    if(!test3){
      if(in.size()!=out.size()) continue;
    }
    input.push_back(in);
    output.push_back(out);
  }
  if(test3){
    unordered_map<char,lint> count;
    unordered_set<char> all_char,top_char;
    char c_zero=0;
    for(auto s:output){
      if(s.size()!=16) continue;
      top_char.insert(s.front());

      for(auto c:s){
        all_char.insert(c);

      }
      char c=s[0];
      if(count.find(c)==count.end()){
        count.insert(make_pair(c,1));
      }else{
        count.at(c)++;
      }

    }

    for(auto c:all_char){
      if(top_char.find(c)==top_char.end()){
        result[0]=c;
        c_zero=c;
        break;
      }
    }
    assert('A'<=c_zero);
    assert(c_zero<='Z');

    vector<pair<char,lint>> vec;
    for(auto p:count){
      if(p.first!=c_zero){
        vec.push_back(p);
      }
    }
    assert(vec.size()==9);
    sort(vec.begin(),vec.end(),compare);
    assert(vec[0].second>=vec[1].second);
    for(int i=0;i<9;i++){
      assert('A'<=vec[i].first);
      assert(vec[i].first<='Z');
      result[i+1]=vec[i].first;
    }
    return result;

  }


  unordered_set<char> found_char;
  for(int i=1;i<=9;i++){
    bool found=false;
    for(int j=0;j<input.size();j++){
      if(input[j].front()=='0'+i){
        if(found_char.find(output[j].front())==found_char.end()){
          found_char.insert(output[j].front());
          result[i]=output[j].front();
          found=true;
          break;
        }
      }
    }
    if(!found){
      abort();
    }
  }

  for(auto s:output){
    for(auto c:s){
      if(found_char.find(c)==found_char.end()){
        result[0]=c;
        return result;
      }
    }
  }
  abort();

}

int main(){
  cout << std::fixed << std::setprecision(16);
  cin.tie(nullptr);
  std::ios::sync_with_stdio(false);
  int t;
  cin>>t;
  for(int i=0;i<t;i++){
    cout<<"Case #"<<i+1<<": "<<Solve()<<endl;


  }

  return 0;
}


