#include <iostream>
#include <cmath>
#include <complex>
#include <string>
#include <sstream>
#include <limits>
#include <numeric>
#include <algorithm>
#include <functional>

#include <map>
#include <vector>

using namespace std;

class bipartite_matching
{
public:
	vector<vector<int>> adj;

	vector<bool> visited;
	vector<int> match;

	int match_count;

public:
	bipartite_matching(int left_vertex_count, int right_vertex_count)
		: adj(), visited(), match(), match_count(0)
	{
		adj.assign(left_vertex_count, vector<int>());

		visited.assign(right_vertex_count, false);
		match.assign(right_vertex_count, -1);
	}

public:
	void process()
	{
		for (int i = 0; i < (int)adj.size(); i++)
		{
			fill(visited.begin(), visited.end(), false);

			if (dfs(i)) match_count++;
		}
	}

	bool dfs(int here)
	{
		for (int there : adj[here])
		{
			if (visited[there]) continue;

			visited[there] = true;
			if (match[there] == -1 || dfs(match[there]))
			{
				match[there] = here;
				return true;
			}
		}

		return false;
	}
};

//bipartite_matching bm(N, M);
//bm.adj[u - 1].push_back(v - 1);
//bm.process();
//int ret = bm.match_count;

struct data_info
{
public:
	char ch;
	int minv;
	int maxv;
	int dist;

public:
	data_info(char _ch, int _minv, int _maxv, int _dist)
	{
		ch = _ch;
		minv = _minv;
		maxv = _maxv;
		dist = _dist;
	}
};

pair<int, int> get_digit(long long n)
{
	int digit = 1;
	while (n >= 10)
	{
		n /= 10;
		digit++;
	}

	return make_pair(digit, n);
}

void process()
{
	int U;
	cin >> U;

	map<char, pair<int, int>> range_info;
	for(int i = 'A'; i <= 'Z'; i++)
	{
		range_info[i] = make_pair(-1, 10);
	}

	for (int i = 1; i <= 10000; i++)
	{
		long long m;
		string s;
		cin >> m >> s;

		if (m != -1)
		{
			pair<int, int> curr = get_digit(m);
			if (curr.first == s.size())
			{
				range_info[s[0]].first = max(range_info[s[0]].first, 1);
				range_info[s[0]].second = min(range_info[s[0]].second, curr.second);
			}
		}
		else
		{
			range_info[s[0]].first = max(range_info[s[0]].first, 1);
		}

		for(int j = 0; j < s.size(); j++)
		{
			range_info[s[j]].first = max(range_info[s[j]].first, 0);
			range_info[s[j]].second = min(range_info[s[j]].second, 9);
		}
	}

	vector<data_info> vlist;

	//ABCDEFGHIJAAAAAA
	//KLMNOP
	//QRSTUVWXYZ

	for (auto e : range_info)
	{
		if (e.second.first != -1)
		{
			vlist.push_back(data_info(e.first, e.second.first, e.second.second, e.second.second - e.second.first));
		}
	}

	if (vlist.size() < 10)
	{
		for (auto e : range_info)
		{
			if (e.second.first == -1)
			{
				vlist.push_back(data_info(e.first, 0, 9, 9));

				if (vlist.size() == 10) break;
			}
		}
	}

	sort(vlist.begin(), vlist.end(), [](const data_info& l, const data_info& r)
		{
			if (l.dist == r.dist)
			{
				return l.minv > r.minv;
			}
			return l.dist < r.dist;
		});

	bipartite_matching bm(vlist.size(), 10);

	for (int i = 0; i < 10; i++)
	{
		for (int j = vlist[i].minv; j <= vlist[i].maxv; j++)
		{
			bm.adj[i].push_back(j);
		}
	}

	bm.process();

	for (int i = 0; i < 10; i++)
	{
		cout << vlist[bm.match[i]].ch;
	}
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);

	int T;
	cin >> T;
	for (int t = 1; t <= T; t++)
	{
		cout << "Case #" << t << ": ";
		process();
		cout << "\n";
	}

	return 0;
}
