#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <map>

using namespace std;

void solve(int tc) {
    int u;
    cin >> u;
    map<char, int> cnt;
    set<char> all;
    for (int i = 0; i < 10000; ++i) {
        long long q;
        string r;
        cin >> q >> r;

        for (char c : r) {
            all.insert(c);
        }
        if (r.size() == u) {
            ++cnt[r[0]];
        }
    }

    string ans;
    for (char c : all) {
        ans.push_back(c);
    }

    sort(ans.begin(), ans.end(), [&](char lhs, char rhs) {
        if (!cnt.count(lhs)) {
            return true;
        }
        if (!cnt.count(rhs)) {
            return false;
        }
        return cnt[lhs] > cnt[rhs];
    });

    cout << "Case #" << tc << ": " << ans << "\n";
}

int main() {
#ifdef DEBUG
    freopen("input", "r", stdin);
#endif
    ios::sync_with_stdio(0);
    cin.tie(0);

    int T;
    cin >> T;
    for (int tc = 1; tc <= T; ++tc) {
        solve(tc);
    }

    return 0;
}
