#include <iostream>
#include <vector>
#include <string>
#include <set>
#include <map>

using std::cin;
using std::cout;
using std::endl;
using std::vector;
using std::string;
using std::set;
using std::map;

using f32 = int_fast64_t;

f32 msd(f32 x)
{
    while (x > 0)
    {
        if (x < 10) return x;
        else x = x / 10;
    }
    return 0;
}

f32 min(f32 a, f32 b)
{
    if (a < b) return a;
    else return b;
}

char infer_zero(const vector<string>& vs)
{
    set<char> l, a;
    for (const auto& s : vs)
    {
        l.insert(s[0]);
        for (const auto& c : s)
        {
            a.insert(c);
        }
        if ((l.size() == 9) && (a.size() == 10))
            break;
    }
    for (auto &c : a)
    {
        if (l.find(c) == l.end()) return c;
    }
    return '0';
}

map<char, f32> get_lims(const vector<f32>& vi, const vector<string>& vs, f32 U)
{
    f32 vi_sz{static_cast<f32>(vi.size())};
    map<char, f32> res;

    for (f32 i = 0; i < vi_sz; ++i)
    {
        if ((static_cast<f32>(vs[i].size()) == U) && (vi[i] > 0))
        {
            if (res.find(vs[i][0]) == res.end())
                res[vs[i][0]] = msd(vi[i]);
            else
                res[vs[i][0]] = min(res[vs[i][0]], msd(vi[i]));
        }
    }
    return res;
}

string collate(char z, const map<char, f32>& lims)
{
    string res;
    res.push_back(z);
    for (f32 i = 1; i < 10; ++i)
    {
        for (const auto& kv : lims)
        {
            if (kv.second == i) res.push_back(kv.first);
        }
    }
    return res;
}

string solve(const vector<f32>& vi, const vector<string>& vs, f32 U)
{
    char z = infer_zero(vs);

    auto lims = get_lims(vi, vs, U);

    auto res = collate(z, lims);

    return res;
}

int main()
{
    f32 T;
    cin >> T;
    for (f32 cas = 0; cas < T; ++ cas)
    {
        f32 U;
        vector<f32> vi;
        vector<string> vs;
        cin >> U;
        for (f32 i = 0; i < 10000; ++i)
        {
            f32 Q_i;
            string R_i;
            cin >> Q_i >> R_i;
            vi.push_back(Q_i);
            vs.push_back(R_i);
        }
        auto res = solve(vi, vs, U);
        cout << "Case #" << cas + 1 << ": " << res << endl;
    }
    return EXIT_SUCCESS;
}
