#include <iostream>
#include <algorithm>
#include <vector>
#include <list>
#include <unordered_map>
#include <unordered_set>
#include <map>
#include <set>
#include <algorithm>
using namespace std;

long long numDigits(long long x) {
  long long num = 0;

  while(x != 0) {
    ++num;
    x /= 10;
  }

  return num;
}

int main() {
  int t;
  // read number of cases
  cin >> t;
  vector<long long> pows(16, 1);

  for (long long i = 1; i < 16; ++i) {
    pows[i] = pows[i - 1] * 10;
  }

  for (int i = 1; i <= t; ++i) {
    int u;
    cin >> u;
    cout << "Case #" << i << ": ";
    vector<int> possibilities('Z' - 'A' + 1, -1);

    for (int j = 1; j <= 10000; ++j) {
      long long q;
      cin >> q;

      string s;
      cin >> s;
      vector<int> maxes(s.size(), 0);
      bool iterate = true;
      //cerr << "q: " << q << endl;
      //cerr << "s: " << s << endl;

      long long exp = pows[s.size() - 1];

      for (long long k = exp; k <= q && iterate; ++k) {
        long long kk = k;
        long long num_digits = numDigits(kk);
        //cerr << "num_digits: " << num_digits << endl;

        if (s.size() == num_digits) {
          for (long long ss = 0; ss < s.size(); ++ss) {
            //cerr << "kk: " << k << endl;
            maxes[s.size() - 1 - ss] = max((int) kk % 10, maxes[s.size() - 1 - ss]);
            kk /= 10;
          }
        }
        
        iterate = s.size() >= num_digits;
      }

      // cerr << "maxes: " << endl;
      // for (long long mm = 0; mm < maxes.size(); ++mm) {
      //   cerr << maxes[mm] << " " ;
      // }
      // cerr << endl;

      for (long long k = 0; k < s.size(); ++k) {
        long long curr = s[k] - 'A';

        if (possibilities[curr] == -1)
          possibilities[curr] = maxes[k];
        else 
          possibilities[curr] = min(possibilities[curr], maxes[k]);
      }
    }

    string result(10, 'z');
    for (long long i = 0; i < possibilities.size(); ++i) {
      //cerr << "posibilities[" << i << "]: " << possibilities[i] << endl;
      if (possibilities[i] > -1)
        result[possibilities[i]] = 'A' + i;
    }

    cout << result << endl;
  }
}
