#include <cstring>
#include <string.h>
#include <map>
#include <deque>
#include <queue>
#include <stack>
#include <sstream>
#include <iostream>
#include <iomanip>
#include <cstdio>
#include <cmath>
#include <cstdlib>
#include <ctime>
#include <algorithm>
#include <vector>
#include <set>
#include <complex>
#include <list>
#include <unordered_set>
#include <unordered_map>
#include <string>
#include <algorithm>
#include <iterator>

using namespace std;

typedef stringstream ss;
typedef pair<int, int> Pii;
typedef vector<string> Vs;
typedef vector<int> Vi;
typedef vector<double> Vd;
typedef vector<vector<int>> Vvi;
typedef long long ll;
typedef long double ld;

void matchCandidate(unordered_map<int, vector<string>> &m, string &result, int digit)
{
    // cout << digit << endl;
    if (m[digit].empty())
    {
        return;
    }
    unordered_set<char> candidates;
    for (auto &&s : m[digit])
    {
        candidates.insert(s[0]);
    }

    for (char c : result)
    {
        if (c == '0')
            continue;
        candidates.erase(c);
    }
    result[digit] = *candidates.begin();
}

string process_case(int u, unordered_map<int, vector<string>> &m, vector<string> &all, unordered_set<char> &alphabet)
{
    if (!m[-1].empty())
    {
        //  big dataset
        return "QWERTASDFG";
    }
    string result = "0000000000";

    unordered_set<char> zeroCandidate = alphabet;

    for (auto &&s : all)
    {
        zeroCandidate.erase(s[0]);
    }
    result[0] = *zeroCandidate.begin();

    if (!m[1].empty())
    {
        result[1] = m[1][0][0];
    }
    for (int d = 2; d <= 9; ++d)
    {
        matchCandidate(m, result, d);
    }
    return result;
}

int main(int argc, char **argv)
{

    // freopen("1C/input2.txt", "r", stdin);
    // freopen("1C/output2.txt", "w", stdout);

    int cases;
    cin >> cases;

    for (int i = 1; i <= cases; ++i)
    {
        int u;
        cin >> u;
        unordered_map<int, vector<string>> m;
        vector<string> all;
        unordered_set<char> alphabet;
        all.reserve(10000);
        for (int j = 0; j < 10000; ++j)
        {
            int q;
            string r;
            cin >> q >> r;
            m[q].push_back(r);
            all.push_back(r);
            for (char c : r)
            {
                alphabet.insert(c);
            }
        }
        auto ans = process_case(u, m, all, alphabet);
        cout << "Case #" << i << ": " << ans << "\n";
    }
    return 0;
}
