#include <algorithm>
#include <bitset>
#include <cassert>
#include <cctype>
#include <climits>
#include <cmath>
#include <cstddef>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <fstream>
#include <functional>
#include <iomanip>
#include <iostream>
#include <iterator>
#include <list>
#include <map>
#include <numeric>
#include <queue>
#include <random>
#include <set>
#include <sstream>
#include <stack>
#include <string>
#include <utility>
#include <vector>
using namespace std;
typedef long long llint;

const char INVALID = '!';

char f(const set<char> &s1, const set<char> &s2) {
  if (s1.size() != s2.size() + 1) {
    return INVALID;
  }
  char ret = INVALID;
  for (const auto &x : s1) {
    if (s2.find(x) == s2.end()) {
      if (ret == INVALID) {
        ret = x;
      } else {
        return INVALID;
      }
    }
  }
  return ret;
}

string gao() {
  const int NQ = 10000;

  int u;
  cin >> u;
  llint b = 1;
  for (int i = 0; i < u - 1; ++i) {
    b *= 10;
  }

  llint m;
  string resp;
  vector<pair<llint, string>> queries;
  set<char> all_characters;
  vector<set<char>> candidates(10);
  for (int i = 0; i < NQ; ++i) {
    cin >> m >> resp;
    queries.push_back(make_pair(m, resp));
    if (m >= b && resp.size() == u) {
      candidates[m / b].insert(resp[0]);
    }
    for (const auto &ch : resp) {
      all_characters.insert(ch);
    }
  }

#ifdef __MY_PC
  for (int i = 1; i <= 4; ++i) {
    cerr << i << ": ";
    copy(candidates[i].begin(), candidates[i].end(),
         ostream_iterator<char>(cerr, " "));
    cerr << endl;
  }
#endif

  // can't handle -1
  if (candidates[1].empty()) {
    return "IMPOSSIBLE";
  }

  string ret;
  map<char, int> h;
  if (candidates[1].empty()) {
    return "IMPOSSIBLE";
  }
  ret.push_back(' ');
  ret.push_back(*(candidates[1].begin()));
  h[*(candidates[1].begin())] = 1;
  for (int i = 2; i <= 4; ++i) {
    auto ch = f(candidates[i], candidates[i - 1]);
    if (ch == INVALID) {
      return "IMPOSSIBLE";
    }
    ret.push_back(ch);
    h[ch] = i;
  }
#ifdef __MY_PC
  cerr << ret << endl;
#endif

  vector<char> perm;
  for (const auto &ch : all_characters) {
    if (h.find(ch) == h.end()) {
      perm.push_back(ch);
    }
  }
  do {
    map<char, int> bp = h;
    for (int i = 0; i < 6; ++i) {
      bp[perm[i]] = (i + 5) % 10;
    }
    bool ok = true;
    for (const auto &p : queries) {
      llint x = 0;
      for (const auto &ch : p.second) {
        x = x * 10 + bp[ch];
      }
      if (x > p.first) {
        ok = false;
        break;
      }
    }
    if (ok) {
      ret[0] = perm[5];
      for (int i = 0; i < 5; ++i) {
        ret.push_back(perm[i]);
      }
      return ret;
    }
  } while (next_permutation(perm.begin(), perm.end()));
  return "IMPOSSIBLE";
}

int main() {
  int tc;
  cin >> tc;
  for (int cc = 1; cc <= tc; ++cc) {
    string ans = gao();
    printf("Case #%d: %s\n", cc, ans.c_str());
  }
  return 0;
}
