#include <iostream>
#include <iomanip>
#include <vector>
#include <set>
#include <unordered_set>
#include <map>
#include <unordered_map>
#include <queue>
#include <deque>
#include <stack>
#include <algorithm>
#include <numeric>
#include <string>
#include <sstream>
#include <cmath>
#include <cstring>
#include <assert.h>
#include <utility>
#include <tuple>
#include <array>
#include <bitset>
#include <cstdlib>

using int64 = long long;

using namespace std;

void solveTest3(int no, const vector<string>& Rs) {
    map<char, int> char_map;

    for (const string& R : Rs) {
        for (char c : R) {
            char_map[c] = -1;
        }
        char_map[R[0]] = -2;    // 0を入れたらダメ
    }
    int d = 1;
    bool filled_zero = false;
    string D(10, ' ');
    for (auto& mp : char_map) {
        if (mp.second == -2 || filled_zero) {
            mp.second = d++;
        } else {
            mp.second = 0;
            filled_zero = true;
        }
        D[mp.second] = mp.first;
    }
    cout << "Case #" << no << ": " << D << endl;
}

void solve(int no) {
    int U;
    cin >> U;

    vector<int64> Ms(10000);
    vector<string> Rs(10000);
    map<char, int> char_map;

    bool is_test3 = true;
    for (int i = 0; i < 10000; i++) {
        cin >> Ms[i] >> Rs[i];
        for (char c : Rs[i]) {
            char_map[c] = -1;
        }
        if (Ms[i] >= 0) {
            is_test3 = false;
        }
    }

    if (is_test3) {
        solveTest3(no, Rs);
        return;
    }

    // 文字列の長さが同じ場合だけを考える
    // 文字列の長さが2文字以上
    //      Mの先頭が1 → Rの先頭は1
    // 文字列の長さが1文字
    //      Mの先頭が1 → Rの先頭は1
    for (int d = 1; d <= 9; d++) {
        for (int i = 0; i < 10000; i++) {
            if (Ms[i] < 0) continue;
            string sM = to_string(Ms[i]);
            if (sM.size() != Rs[i].size() || sM[0] != '0' + d) continue;

            // すでに決まっている数字は無視
            if (char_map[Rs[i][0]] >= 0) continue;

            // Rs[i][0] は 1以上d以下の数字
            // 1以上d未満の数字についてはすでに割り当てが決定しているので
            char_map[Rs[i][0]] = d;
            break;
        }
    }

    string D(10, ' ');
    for (auto& mp : char_map) {
        if (mp.second < 0) {
            mp.second = 0;
        }
        D[mp.second] = mp.first;
    }

    cout << "Case #" << no << ": " << D << endl;
}

int main() {
    cin.tie(nullptr);
    ios::sync_with_stdio(false);

    int T;
    cin >> T;

    for (int no = 1; no <= T; no++) {
        solve(no);
    }

    return 0;
}

