#include <iostream>
#include <vector>
#include <unordered_set>
#include <unordered_map>
#include <map>
#include <queue>
using namespace std;


void permuteRecursive(vector<char> &num, int begin, vector<vector<char> > &result)	{
  if (begin >= num.size()) {
    // one permutation instance
    result.push_back(num);
    return;
  }

  for (int i = begin; i < num.size(); i++) {
    swap(num[begin], num[i]);
    permuteRecursive(num, begin + 1, result);
    // reset
    swap(num[begin], num[i]);
  }
}

void Solve(int test_id) {
  int U;
  cin >> U;

  vector<char> ans(10, 0);
  unordered_map<int, unordered_set<char>> digits;
  unordered_set<char> cs;
  int known = 0;

  vector<vector<pair<string, unsigned long long>>> all;
  for (size_t i = 0; i < 16; ++i) {
    vector<pair<string, unsigned long long>> tmp;
    all.push_back(tmp);
  }
  for (size_t i = 0; i < 1e4; ++i) {
    unsigned long long val;
    string s;
    cin >> val;
    cin >> s;
    all[s.size() - 1].emplace_back(s, val);
    for (size_t j = 0; j < s.size(); ++j) cs.insert(s[j]);
    if (val < 10) {
      digits[val].insert(s[0]);
    }
  }
  for (size_t i = 1; i < 10; ++i) {
    if (digits[i].size() == 1) {
      ++known;
      ans[i] = *digits[i].begin();
      cs.erase(*digits[i].begin());
      for (size_t j = i + 1; j < 10; ++j) {
        digits[j].erase(ans[i]);
      }
    } else {
      break;
    }
  }
  if (known == 9) {
    ans[0] = *cs.begin();
    for (size_t i = 0; i < ans.size(); ++i) cout << ans[i];
    cout << endl;
    return;
  }
  vector<char> remain;
  for (char c : cs) {
    remain.push_back(c);
  }

  for (size_t i = 0; i < ans.size(); ++i) cout << ans[i];
  cout << endl;
}

int main() {
    int num_tests;
    cin >> num_tests;
    for (int i = 1; i <= num_tests; ++i) {
        cout << "Case #" << i << ": "; 
        Solve(i);
    }
    return 0;
}
