#include <string>
#include <iostream>
#include <random>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <algorithm>

const int SZ = 10000;
int pos[30][30];
int prob[30][30];
int values[30][10];

int main() {
    std::random_device rd;
    std::mt19937_64 gen(rd());
    int T, U;
    std::cin >> T;
    std::string R;
    long long Q;

    for(int test = 1; test <= T; ++test) {
        std::cin >> U;
        long long v = 1;
        for(int i = 0; i < 30; ++i) for(int j = 0; j < 30; ++j) prob[i][j] = 0;
        for(int i = 0; i < 30; ++i) for(int j = 0; j < 30; ++j) pos[i][j] = 0;
        for(int i = 0; i < U; ++i)
            v *= 10;
        v -= 1;

        std::uniform_int_distribution<long long> dis(1, v);
        for(int cs = 0; cs < SZ; ++cs) {
            std::cin >> Q >> R;
            int actual = 0;
            long long left = dis(gen);
            std::uniform_int_distribution<long long>nxt(1, left);
            long long candidate = nxt(gen);

            while (candidate > 0) {
                ++prob[actual][candidate % 10];
                candidate /= 10;
                ++actual;
            }

            actual = 0;
            for(int i = 0; i < R.size(); ++i) {
                int p = R.size() - i - 1;
                int cur = R[p] - 'A';
                ++pos[actual][cur];
                ++actual;
            }
        }

        std::vector<std::pair<int, int>> values;
        std::set<int> achars;
        std::set<int> nchars;
        for(int v = 0; v < 30; v++) {
            if (pos[0][v] > 0) {
                achars.insert(v);
            }

            if (pos[U - 1][v] > 0) {
                values.push_back(std::make_pair(pos[U - 1][v], v));
                nchars.insert(v);
            }
        }
        std::sort(values.begin(), values.end());
        std::reverse(values.begin(), values.end());
        std::string answer = "";

        for(int candidate: achars) {
            auto it = nchars.find(candidate);
            if (it != nchars.end()) {
                continue;
            }

            answer += char('A' + candidate);
        }

        for(int i = 1; i < 10; ++i) {
            answer += char('A' + values[i - 1].second);
        }

        std::cout << "Case #" << test << ": " << answer << std::endl;
    }
}