#include <iostream>
#include <unordered_set>
#include <string>
#include <sstream>
#include <vector>

using namespace std;

using CharSet = unordered_set<char>;
using Data = array<pair<uint64_t, string>, 10000>;

CharSet createCharSet(const Data& d) {
  CharSet charSet;
  for (const auto& item : d) {
    if (charSet.size() == 10) return charSet;
    string s = item.second;
    for (char c : s)
      charSet.insert(c);
  }
}

char findZero(const Data& d, CharSet& charSet) {
  unordered_set<char> set;
  for (const auto& item : charSet) {
    set.insert(item);
  }
  for (const auto& item : d) {
    char c = item.second[0];
    set.erase(c);
    if (set.size() == 1) {
      charSet.erase(*set.begin());
      return *set.begin();
    }
  }
}

char to_char(int n) {return n + '0';}

char findN(int n, const Data& d, CharSet& charSet) {
  for (const auto& item : d) {
    string q = to_string(item.first);
    const string& r = item.second;
    if (q.length() != r.length()) continue;
    if (q[0] == to_char(n)) {
      if (charSet.count(r[0]) == 0) continue;
      charSet.erase(r[0]);
      return r[0];
    }
  }
}

string computeResult(int U, const Data& d) {
  string res;
  CharSet charSet = createCharSet(d);
  res.append(1, findZero(d, charSet));
  for (int i=1; i<=9; ++i) {
    res.append(1, findN(i, d, charSet));
  }
  return res;
}

int main() {
  int T;
  cin >> T;
  for (int i=0; i<T; ++i) {
    int U;
    cin >> U;
    Data array;
    for (int i=0; i<10000; ++i) {
      uint64_t q;
      string r;
      cin >> q >> r;
      array[i] = make_pair(q,r);
    }
    cout << "Case #"<<i+1<<": "<<computeResult(U, array)<<endl;
  }

  return 0;
}
