#include <algorithm>
#include <iostream>
#include <map>
#include <set>
#include <string>
#include <vector>

#define MAX 10000

using namespace std;

void single_case(int caseNo) {
    int U;
    cin >> U;

    set<char> alphabet;

    vector<string> Q(MAX);
    vector<string> R(MAX);
    for (int i = 0; i < MAX; ++i) {
        cin >> Q[i] >> R[i];
        for (char c : R[i]) {
            alphabet.insert(c);
        }
    }

    string D(10, 'x');

    if (Q[0][0] == '-') {
        {
            set<char> isFirst;
            for (const string& r : R) {
                if (r.length() == U) {
                    isFirst.insert(r[0]);
                }
            }
            for (char c : alphabet) {
                if (isFirst.find(c) == isFirst.end()) {
                    D[0] = c;
                    break;
                }
            }
        }

        map<char, int> distribution;
        for (const string& r : R) {
            if (r.length() != U) {
                continue;
            }
            auto it = distribution.find(r[0]);
            if (it == distribution.end()) {
                distribution[r[0]] = 1;
            } else {
                it->second += 1;
            }
        }

        vector<pair<int, char>> characters;
        for (const auto& entry : distribution) {
            characters.push_back({entry.second, entry.first});
        }

        sort(characters.begin(), characters.end());
        for (int i = 0; i < 9; ++i) {
            D[i+1] = characters[8-i].second;
        }
    } else {
        vector<bool> assigned(128, false);

        for (int k = 1; k <= 9; ++k) {
            for (int i = 0; i < MAX; ++i) {
                if (Q[i][0] == '0' + k && Q[i].length() == R[i].length()) {
                    char candidate = R[i][0];
                    if (!assigned[candidate]) {
                        D[k] = candidate;
                        assigned[candidate] = true;
                        break;
                    }
                }
            }
        }

        for (char c : alphabet) {
            if (!assigned[c]) {
                D[0] = c;
                break;
            }
        }
    }

    cout << "Case #" << caseNo << ": " << D << endl;
}

int main() {
    int T = 0;
    cin >> T;
    for (int i = 1; i <= T; ++i) {
        single_case(i);
    }
    return 0;
}
