#include <algorithm>
#include <cstdint>
#include <ios>
#include <iostream>
#include <map>
#include <set>
#include <string>
#include <utility>
#include <vector>

using namespace std;

void solve()
{
    int u;
    cin >> u;

    int64_t q;
    string r;
    map<char, size_t> count;
    set<char> chars;
    for (int i = 0; i < 10000; ++i)
    {
        cin >> q >> r;
        count[r[0]]++;
        for (char c : r)
            chars.insert(c);
    }

    char zero = '\0';
    for (char c : chars)
    {
        if (count.find(c) == count.end())
        {
            zero = c;
        }
    }

    vector<pair<char, size_t>> occurrences;
    for (const auto& entry : count)
    {
        occurrences.push_back(entry);
    }
    sort(
        occurrences.begin(), occurrences.end(),
        [](const pair<char, size_t>& a, const pair<char, size_t>& b) {
            return a.second > b.second;
        });
    cout << zero;
    for (const auto& entry : occurrences)
    {
        cout << entry.first;
    }
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;
    for (int i = 1; i <= t; ++i)
    {
        cout << "Case #" << i << ": ";
        solve();
        cout << endl;
    }
}
