#include <iostream>
#include <vector>
#include <set>
#include <string>
#include <sstream>
#include <algorithm>

typedef unsigned int uint;
typedef long long int lli;
typedef std::pair<lli, std::string> pllis;
typedef std::pair<int, char> pic;

class overrandomized
{
	private:
		static const int QRCNT = 10000;

		uint u;
		std::vector<pllis> qrs;

	public:
		overrandomized() {}

		void input(std::istream &is) {
			is >> u;
			qrs.resize(QRCNT);
			for (pllis &qr : qrs) {
				is >> qr.first >> qr.second;
			}
		}

		std::string solve() {
			std::set<char> ls;
			std::vector<int> freq('Z' - 'A' + 1, 0);
			for (const pllis &qr : qrs) {
				const std::string &r = qr.second;
				char fc = r.at(0);
				if ((fc < 'A') || (fc > 'Z')) {
					continue;
				}
				if (r.size() < u) {
					freq.at(fc - 'A') += 1;
				} else {
					freq.at(fc - 'A') += 10;
				}
				for (const char &d : r) {
					if ((d < 'A') || (d > 'Z')) {
						continue;
					}
					ls.insert(d);
				}
			}
			std::vector<pic> cwfreq;
			cwfreq.reserve(ls.size());
			for (const char &d : ls) {
				cwfreq.push_back(std::make_pair(freq.at(d - 'A'), d));
			}
			std::sort(cwfreq.begin(), cwfreq.end());
			std::string sol;
			if (cwfreq.size() != 10) {
				sol = "----------";
			} else {
				sol.push_back(cwfreq.at(0).second);
				for (uint i = 9; i > 0; --i) {
				       sol.push_back(cwfreq.at(i).second);
				}
			}
			std::ostringstream oss;
			oss << sol;
			return oss.str();
		}
};

int main(void) {
	int nt;
	std::cin >> nt;
	for (int znj = 0; znj < nt; ++znj) {
		overrandomized task;
		task.input(std::cin);
		std::cout << "Case #" << (znj + 1) << ": " << task.solve() << std::endl;
	}
	return 0;
}
