#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <queue>
#include <string>
#include <map>
#include <set>
#include <stack>
#include <tuple>
#include <deque>
#include <numeric>
#include <bitset>
#include <iomanip>
#include <cassert>
#include <chrono>
#include <random>
#include <limits>
#include <iterator>
#include <functional>
#include <sstream>
#include <complex>
using namespace std;

typedef long long ll;
typedef uint64_t ull;
typedef pair<int, int> P;
constexpr double PI = 3.1415926535897932;   // acos(-1)
constexpr double EPS = 1e-9;
constexpr int INF = 1001001001;
constexpr int mod = 1000000007;
// constexpr int mod = 998244353;

#define chmax(x, y) x = max(x, y)
#define chmin(x, y) x = min(x, y)

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    constexpr int q = 1e+4;
    int T;
    cin >> T;
    for(int loop = 0; loop < T; ++loop){
        int U;
        cin >> U;
        if(U == 16){
            cout << '\n';
            continue;
        }

        vector<int> Q(q);
        vector<string> R(q);
        set<char> st;
        for(int i = 0; i < q; ++i){
            cin >> Q[i] >> R[i];
            int n = R[i].length();
            for(int j = 0; j < n; ++j)  st.insert(R[i][j]);
        }

        vector<char> ch;
        for(auto it : st)   ch.push_back(it);

        vector<int> perm(10);
        for(int i = 0; i < 10; ++i) perm[i] = i;
        
        string ans = "";
        do{
            string str = "";
            for(int i = 0; i < 10; ++i) str += ch[perm[i]];
            map<char, char> mp;
            for(int i = 0; i < 10; ++i) mp[str[i]] = (char)'0' + i;

            bool ok = true;
            for(int i = 0; i < q; ++i){
                string s = "";
                for(int j = 0; j < R[i].length(); ++j){
                    s += mp[R[i][j]];
                }
                if(s[0] == '0'){
                    ok = false;
                    break;
                }
                int foo = stoi(s);
                if(foo > Q[i]){
                    ok = false;
                    break;
                }
            }

            if(ok){
                ans = str;
                break;
            }
            
        }while(next_permutation(perm.begin(), perm.end()));

        cout << "Case #" << loop + 1 << ": " << ans << '\n';
    }
}