#include <bits/stdc++.h>

struct Edge {
    int f;
    int t;
    
    Edge(int f, int t) : f(f), t(t) {}
};

std::string Hungary(const std::vector<std::vector<int>>& edges, const std::vector<char>& dict) {
    std::vector<int> match(20);
    std::vector<int> check(20);
    std::vector<int> prev(20);
    std::queue<int> queue;
    for (int i = 0; i < match.size(); ++i) {
        match[i] = -1;
        check[i] = -1;
    }
    
    for (int i = 0; i < 10; ++i) {
        if (match[i] == -1) {
            while (queue.size()) queue.pop();
            queue.push(i);
            prev[i] = -1;
            bool ok = false;
            while (queue.size() && !ok) {
                int u = queue.front();
                for (auto v : edges[u]) {
                    if (ok) {
                        break;
                    }
                    if (check[v] != i) {
                        check[v] = i;
                        if (match[v] >= 0) {
                            prev[match[v]] = u;
                        } else {
                            ok = true;
                            int d = u, e = v;
                            while (d != -1) {
                                int t = match[d];
                                match[d] = e;
                                match[e] = d;
                                d = prev[d];
                                e = t;
                            }
                        }
                        queue.push(match[v]);
                    }
                }
                queue.pop();
            }
        }
    }
    std::string ans;
    for (int i = 0; i < 10; ++i) {
        if (match[i+10] == -1) {
            ans += 'Z';
        } else {
            ans += dict[match[i + 10]];
        }
    }
    return ans;
}

int main() {
    int T;
    scanf("%d", &T);
    for (int t = 1; t <= T; ++t) {
        int length;
        std::vector<std::pair<std::string, std::string>> pairs(4000);
        scanf("%d", &length);
        std::vector<char> dic;
        std::set<std::pair<char, int>> disable;
        std::set<char> chs;
        std::vector<char> dict;
        for (int i = 0; i < 10000; ++i) {
            std::string a, b;
            std::cin >> a >> b;
            disable.insert({b[0], 0});
            for (auto c : b) {
                if (!chs.count(c)) {
                    chs.insert(c);
                    dict.push_back(c);
                }
            }
            if ((a == "-1") || a.length() != b.length()) {
                continue;
            }
            int head = a[0] - '0';
            for (int d = head + 1; d < 10; ++d) {
                disable.insert({b[0], d});
            }
        }
        std::vector<std::vector<int>> edges(20);
        for (int i = 0; i < dict.size(); ++i) {
            char c = dict[i];
            for (int d = 0; d < 10; ++d) {
                if (!disable.count({c, d})) {
                    edges[i].push_back(d + 10);
                    edges[d+10].push_back(i);
                }
            }
        }
        
        std::cout << "Case #" << t << ": " << Hungary(edges, dict) << std::endl;
    }
    
}