#include <iostream>
#include <sstream>
#include <fstream>
#include <vector>
#include <algorithm>
#include <numeric>
#include <limits>
#include <stdexcept>
#include <stack>


int tos(std::string &s) {
    int x;
    std::istringstream os(s);
    os >> x;
    return x;
}

struct record {
    std::string Q;
    std::string R;
    int c;
};

std::string repeat9(int x) {
    std::string s;
    for (int i = 0; i < x; i++) s += "9";
    return s;
}

int main(int argc, char const *argv[]) {
    std::ios_base::sync_with_stdio(false);

    std::istream &fp = std::cin;
    //std::fstream fp("/Users/lore/Desktop/CodeJam2020/sample.in");

    int T; fp >> T;

    for (int t = 1; t <= T; t++) {
        int U; fp >> U;

        const int G = 10000;

        std::vector<record> q(G);

        std::vector<int> Q(G);
        std::vector<std::string> Qs(G);
        std::vector<std::string> R(G);

        std::vector<int> max_possible(26, 11); // max possible value for letter i - 'A'

        for (int i = 0; i < G; i++) {
            fp >> q[i].Q >> q[i].R;
            q[i].c = tos(q[i].Q);

            if (q[i].c < 0 || q[i].Q.size() > q[i].R.size()) {
                q[i].Q = repeat9(q[i].R.size());
            }

            for (char c : q[i].R) {
                max_possible[c - 'A'] = 10;
            }
            //while (q[i].Q.size() < U) q[i].Q = "0" + q[i].Q;
        }

        for (int i = 0; i < G; i++) {
            int digit = q[i].Q[0] - '0';
            int letter = q[i].R[0] - 'A';

            max_possible[letter] = std::min(max_possible[letter], digit);
        }

        std::string res = "??????????";
        for (int i = 0; i <= 10; i++) {
            for (char l = 'A'; l <= 'Z'; l++) {
                if (max_possible[l - 'A'] == i) {
                    res[i % 10] = l;
                }
            }
        }

        std::cout << "Case #" << t << ": " << res << "\n";
    }
}
