#include <bits/stdc++.h>

int main() {
    int tests;
    scanf("%d", &tests);
    for (int t = 1; t <= tests; ++t) {
        int u;
        scanf("%d", &u);
        std::vector<std::pair<std::string, std::string>> queries;
        std::map<char, int> max_digit_for_char, char_count;
        for (int i = 0; i < 10000; ++i) {
            char buf1[20], buf2[20];
            scanf(" %s %s", buf1, buf2);
            queries.emplace_back(buf1, buf2);
            for (char c : queries.back().second) {
                max_digit_for_char[c] = 9;
                char_count[c] = 0;
            }
        }

        for (auto &query : queries) {
            std::string num = query.first;
            std::string str = query.second;
            if (str.size() > 1) {
                ++char_count[str[0]];
            }
        }

        printf("Case #%d: ", t);

        int max_solved_digit = -1;
        while (max_solved_digit < 9) {
            bool changed = false;
            for (auto &query : queries) {
                std::string num = query.first;
                std::string str = query.second;
                if (num[0] == '-') {
                    break;
                }
                if (str.size() == num.size()) {
                    int digit = num[0] - '0';
                    if (digit < max_digit_for_char[str[0]]) {
                        max_digit_for_char[str[0]] = digit;
                        changed = true;
                    }

                    if (max_digit_for_char[str[0]] == max_solved_digit + 1) {
                        ++max_solved_digit;
                        printf("%c", str[0]);
                        changed = true;
                    }
                }
            }

            if (!changed) {
                char best_chr;
                int score = 0;
                for (auto &item : char_count) {
                    if (max_solved_digit == -1 && item.second == 0) {
                        best_chr = item.first;
                    } else if (max_solved_digit >= 0 && item.second > score
                            && max_digit_for_char[item.first] > max_solved_digit) {
                        best_chr = item.first;
                        score = item.second;
                    }
                }

                max_digit_for_char[best_chr] = ++max_solved_digit;
                printf("%c", best_chr);
            }
        }

        printf("\n");
    }
}
