#include <bits/stdc++.h>

using namespace std;

using ll = long long;

ll u;

set<char> possibility[10];
char res[10];
vector<pair<string, string>> queries;

int getDigit(char c)
{
    for(int i = 0; i < 10; ++i)
        if(res[i] == c)
            return i;
    return -1;
}

void erasePossibility(int digit, char c)
{
    if(possibility[digit].find(c) == possibility[digit].end())
        return;

    possibility[digit].erase(possibility[digit].find(c));
    if(possibility[digit].size() == 1 && res[digit] == 0)
    {
        res[digit] = *possibility[digit].begin();
        for(int i = 0; i < 10; ++i)
            if(i != digit)
                erasePossibility(i, res[digit]);
    }
}

bool hasRes()
{
    for(int i = 0; i < 10; ++i)
        if(res[i] == 0)
            return false;
    return true;
}

int toDigit(char c)
{
    return c - '0';
}

void solve()
{
    cin >> u;

    for(int i = 0; i < 10; ++i)
    {
        res[i] = 0;
        possibility[i].clear();
        for(char j = 'A'; j <= 'Z'; ++j)
            possibility[i].insert(j);
    }

    queries.clear();

    for(int i = 0; i < 10000; ++i)
    {
        string a, b;

        cin >> a >> b;

        queries.push_back(make_pair(a, b));

        if(a == "-1")
            throw std::runtime_error("oops");
    }

    {
        set<char> used;
        for(const auto &it: queries)
            for(const auto &c: it.second)
                used.insert(c);

        if(used.size() != 10)
            throw std::runtime_error("ooops");

        for(char c = 'A'; c <= 'Z'; ++c)
            if(used.find(c) == used.end())
                for(int d = 0; d < 10; ++d)
                    erasePossibility(d, c);
    }

    for(const auto &it: queries)
        erasePossibility(0, it.second.front());

    while(!hasRes())
    {
        for(const auto &it: queries)
        {
            string num = it.first;
            string s = it.second;

            if(num.size() > s.size())
                continue;

            for(int i = 0; i < num.size(); ++i)
            {
                if(getDigit(s[i]) == -1)
                {
                    if(i == 0)
                        erasePossibility(0, s[i]);
                    for(int j = toDigit(num[i]) + 1; j <= 9; ++j)
                        erasePossibility(j, s[i]);
                    break;
                }
                else
                {
                    if(toDigit(num[i]) > getDigit(s[i]))
                        break;
                }
            }
        }
    }

    {
        string tmp;
        for(int i = 0; i < 10; ++i)
            tmp.push_back(res[i]);
        cout << tmp;
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

#ifdef LOCAL
    freopen("in.txt", "r", stdin);
    freopen("out.txt", "w", stdout);
#endif // LOCAL

    int t; cin >> t;
    for(int i = 1; i <= t; ++i)
    {
        cout << "Case #" << i << ": ";
        solve();
        cout << endl;
    }

    return 0;
}
