#include <algorithm>
#include <cstdio>

int tests;
int digits;
bool letter[32];
bool not_zero[32];
int at_most[32];

int main(void)
{
    scanf("%d", &tests);
    for(int t = 0; t < tests; ++t)
    {
        scanf("%d", &digits);
        for(int i = 0; i < 32; ++i)
        {
            letter[i] = false;
            not_zero[i] = false;
            at_most[i] = 9;
        }

        for(int e = 0; e < 10000; ++e)
        {
            char question[32] = {};
            char result[32] = {};
            scanf("%s %s", question, result);
            if(result[1])
                not_zero[result[0] - 'A'] = true;

            for(int s = 0; result[s]; ++s)
                letter[result[s] - 'A'] = true;

            bool same_size = true;
            for(int s = 0; same_size && question[s]; ++s)
                same_size = result[s];

            if(question[0] != '-' && same_size)
                at_most[result[0] - 'A'] = std::min(at_most[result[0] - 'A'], question[0] - '0');
        }

        for(int i = 0; i < 32; ++i)
        {
            if(letter[i] && !not_zero[i])
                at_most[i] = 0;
        }

        char solution[32] = {};
        for(int i = 0; i < 32; ++i)
            for(int a = at_most[i]; letter[i] && a >= 0; --a)
            {
                if(!solution[a])
                {
                    solution[a] = i + 'A';
                    break;
                }
            }

        printf("Case #%d: %s\n", t + 1, solution);
    }
}
