#include <iostream>
#include <algorithm>
#include <vector>


std::string solve(int U) {
    int lead_counter[256] = {0};
    int tot_counter[256] = {0};
    long long Qi;
    std::string res;
    for (int i = 0; i < 10000; ++i) {
        std::cin >> Qi >> res;
        lead_counter[res[0]]++;
        for (auto& c: res)
            tot_counter[c]++;
    }
    std::vector<std::pair<int, char>> rating;
    for (int i = 0; i < 256; ++i) {
        if (!tot_counter[i])
            continue;
        rating.emplace_back(lead_counter[i], (char)i);
    }
    std::sort(rating.begin(), rating.end());
    std::string s;
    s.resize(10);
    s[0] = rating[0].second;
    for (int i = 1; i <= 9; ++i) {
        s[i] = rating[10 - i].second;
    }
    return s;
}

int main() {
    std::ios_base::sync_with_stdio(false);
    int U, T;
    
    std::cin >> T;
    for (int i = 1; i <= T; ++i) {
        std::cin >> U;
        std::cout << "Case #" << i << ": " << solve(U) << '\n';
    }
    return 0;
}