#include <iostream>
#include <vector>
#include <math.h>
#include <sstream>
#include <vector>
#include <algorithm>
#include <map>
#include <unordered_map>
#include <set>

using namespace std;

string getDecodeString(vector<pair<int, string>> & values)
{
  set<char> chars;
  unordered_map<string, int> valuesMap;

  sort(begin(values), end(values), [](pair<int, string> const& lhs, pair<int, string> const& rhs)
    {
      return lhs.first < rhs.first;
    });

  for (pair<int, string> const& value : values)
  {
    if (value.first < 10)
    {
      if (valuesMap.count(value.second) > 0)
      {
        continue;
      }
      valuesMap.insert({ value.second, value.first });
    }
    else if (chars.size() < 10)
    {
      for (char c : value.second)
      {
        chars.insert(c);
      }
    }
  }
  
  for (char c : chars)
  {
    string tmp;
    tmp.assign(1, c);
    if (valuesMap.count(tmp) == 0)
    {
      valuesMap.insert({ tmp, 0 });
    }
  }

  map<int, string> outMap;
  for (auto& val : valuesMap)
  {
    outMap.insert({ val.second, val.first });
  }

  stringstream out;
  for (auto& val : outMap)
  {
    out << val.second;
  }

  return out.str();
}

int main()
{
  int cases;
  cin >> cases;

  for (int i = 0; i < cases; ++i)
  {
    unsigned long long upperBound;
    cin >> upperBound;
    upperBound = (unsigned long long)pow(10, upperBound);

    vector<pair<int, string>> values;
    int tmp;
    string tmpStr;
    for (int i = 0; i < 10000; ++i)
    {
      cin >> tmp;
      cin.get();
      getline(cin, tmpStr);
      values.emplace_back(tmp, tmpStr);
    }

    cout << "Case #" << i + 1 << ": " << getDecodeString(values);
    cout << endl;
  }
}