#include <algorithm>
#include <cstdio>
#include <map>
#include <queue>
#include <set>
#include <sstream>
#include <string>
#include <vector>
#include <iostream>

#include <pthread.h>

const bool MULTITHREADED = true;
const int NUM_WORKERS = 8;

using std::string;
using std::vector;

void init_globals() {
}

struct char_data {
    char c;
    int refs;
};

bool operator< (const char_data& a, const char_data& b) {
    return a.refs > b.refs;
}

struct input_t {
    void read() {
        int _;
        std::cin >> _;
        string x, t;
        for (int i = 0; i < 10000; i++) {
            std::cin >> x >> t;
            m[t[0]]++;
            for (int j = 1; j < t.size(); j++) s.insert(t[j]);
        }
    }

    std::map<char, int> m;
    std::set<char> s;
};

struct output_t {
    void write(const int& case_number) {
        std::cout << "Case #" << case_number << ": ";

        std::cout << s;

        std::cout << '\n';
    }

    string s;
};

output_t solve(input_t& input) {
    vector<char_data> cd;
    for (auto it = input.m.begin(); it != input.m.end(); it++) {
        char_data c;
        c.c = it->first;
        c.refs = it->second;
        cd.push_back(c);
    }
    std::sort(cd.begin(), cd.end());

    output_t out;
    for (char c : input.s) if (input.m[c] == 0) out.s += c;
    for (const char_data& c : cd) out.s += c.c;
    return out;
}

struct environment {
    environment(vector<input_t>& in, vector<output_t>& out)
        : input(in), output(out), task_queue() {

        for (int i = 0; i < (int)input.size(); i++) task_queue.push(i);
        pthread_mutex_init(&queue_mutex, NULL);
    }

    ~environment() {
        pthread_mutex_destroy(&queue_mutex);
    }

    vector<input_t>& input;
    vector<output_t>& output;
    std::queue<int> task_queue;
    pthread_mutex_t queue_mutex;
};

void* worker_thread(void* _env) {
    environment& env = *(reinterpret_cast<environment*>(_env));

    while (true) {
        int task = -1;
        pthread_mutex_lock(&env.queue_mutex);
        if (!env.task_queue.empty()) {
            task = env.task_queue.front();
            env.task_queue.pop();
        }
        pthread_mutex_unlock(&env.queue_mutex);

        if (task == -1) break;

        env.output[task] = solve(env.input[task]);
    }

    return NULL;
}

void solve_all(vector<input_t>& input, vector<output_t>& output) {
    environment env(input, output);

    vector<pthread_t> threads(NUM_WORKERS);
    for (int i = 0; i < NUM_WORKERS; i++)
        pthread_create(&(threads[i]), NULL, worker_thread, &env);

    for (int i = 0; i < NUM_WORKERS; i++)
        pthread_join(threads[i], NULL);
}

int main() {
    init_globals();

    int tests;
    string line;
    std::getline(std::cin, line);
    std::istringstream iss(line);
    iss >> tests;

    vector<input_t> input(tests);
    vector<output_t> output(tests);
    for (int i = 0; i < tests; i++)
        input[i].read();

    if (MULTITHREADED)
        solve_all(input, output);
    else
        for (int i = 0; i < tests; i++)
            output[i] = solve(input[i]);

    for (int i = 0; i < tests; i++)
        output[i].write(i+1);

    return 0;
}
