#include <iostream>
#include <vector>
#include <set>
#include <algorithm>
#include <map>
using namespace std;

typedef long long ll;
const int MAXN = 100000 + 5;
const int INF = 1e9, MOD = 1e9 + 7;
 
void solve() {
   
   int u;
   set<char> letters;
   
   vector<ll> q(10000);
   vector<string> res(10000);
   
   cin >> u;
   
   for(int i=0; i<10000; i++) {
		cin >> q[i] >> res[i];
		for(int j=0; j<res[i].size(); j++)
			letters.insert(res[i][j]);
   }
   
   if(q[0] != -1) {
	   int k = 0;
	   vector<char> val;
	   map<char,int> mapa;
	   
	   for(auto c:letters) {
			val.push_back(k);
			mapa[c] = k;
			k++;
	   }
			
		string sol = "IMPOSSIBLE";
		
		do {
			
			bool ok = 1;
			
			for(int i=0; i<10000; i++) {
				ll broj = 0;
				for(int j=0; j<res[i].size(); j++)
					broj = broj * 10 + val[mapa[res[i][j]]];
					
				if(broj > q[i] || val[mapa[res[i][0]]]==0) {
					ok = 0;
					break;
				}
				
				
			}
			
			if(ok) {
				sol = "";
				for(int i=0; i<10; i++) {
					for(auto c:letters)
						if(val[mapa[c]] == i)
							sol += c;
				}
			
			}
				
		}
		while(next_permutation(val.begin(), val.end()));
		
		cout << sol;
   }
   
   else {
   	
   		map<char,int> freq;
   		
   		for(int i=0; i<10000; i++) 
   			if(res[i].size() == 16) freq[res[i][0]]++;
   		
   		vector< pair<int,char> > freq_let;
   		
   		for(auto c:letters) {
   			freq_let.push_back(make_pair(freq[c], c));
   		}
   		
   		sort(freq_let.begin(), freq_let.end());
   		
   		int ok = 1;
   		
   		for(int i=1; i<10; i++)
   			if(freq_let[i].first < freq_let[i-1].first * 0.7 * (i+1))
   				ok = 0;
   		
   			
   		if(freq_let[0].first != 0 || ok == 0)
   			 cout << "IMPOSSIBLE";
   			
   		else {
   			string sol = "";
   			
   			for(int i=0; i<freq_let.size(); i++)
   				sol += freq_let[i].second;
   				
   			cout << sol;
   		}
   	
   }
	
}
 
int main() {
 
    int t;
 
    cin >> t; 
 
    for(int i=1; i<=t; i++) {
        cout << "Case #" << i << ": ";
        solve();
        cout << endl;
    }
 
    return 0;
}