/* Author haleyk10198 */
/* 作者:  haleyk10198 */
/* CF handle: haleyk100198*/
/* FOR ACM-ICPC WF*/
#include <bits/stdc++.h>

using namespace std;
using ll = long long;
using vi = vector<int>;
using vvi = vector<vi>;
using pii = pair<int, int>;

#define pb push_back

constexpr auto MOD = 1000000007LL;
constexpr auto LINF = (1LL << 60);
constexpr auto INF = 2147483647LL;
constexpr auto PI = 3.1415926535897932384626433;
constexpr auto EPS = 1E-9;

template<typename T1, typename T2>
ostream &operator<<(ostream &out, const pair<T1, T2> p) {
    out << p.first << ' ' << p.second;
    return out;
}

template<typename T1, typename T2>
istream &operator>>(istream &in, pair<T1, T2> &p) {
    in >> p.first >> p.second;
    return in;
}

template<typename T>
istream &operator>>(istream &in, vector<T> &v) {
    for (auto &x: v)
        in >> x;
    return in;
}

template<typename T>
ostream &operator<<(ostream &out, vector<T> v) {
    for (int i = 0; i < v.size(); i++)
        out << v[i] << (i + 1 == v.size() ? '\n' : ' ');
    out.flush();
    return out;
}

#if __cplusplus < 201703L
#define mp make_pair
#endif

int n, m;

inline bool check(vi &v) {
    for(int i = 0, j = 0; j+1 < v.size(); i = v[i], j++) {
        if((v[i]-1)%n != j/n) {
            return false;
        }
    }
    return true;
}

map<vi, pii> vis;

vi v;

map<char, int> nxt[200010], cnt[200010];
int nodeCount = 1;

void insert(string numberString) {
    int trieId = 0;
    for(auto digit: numberString) {
        if(!nxt[trieId].count(digit)) {
            nxt[trieId][digit] = nodeCount++;
        }
        cnt[trieId][digit]++;
        trieId = nxt[trieId][digit];
    }

    return;
}

static unsigned long x=123456789, y=362436069, z=521288629;
unsigned long gen(void) {          //period 2^96-1
    unsigned long t;
    x ^= x << 16;
    x ^= x >> 5;
    x ^= x << 1;

    t = x;
    x = y;
    y = z;
    z = t ^ x ^ y;

    return z;
}

const char* SAMPLE = "CODEJAMFUN";

void populateInputFile() {
    freopen("input.txt","w",stdout);
    cout << 1 << endl << 2 << endl;
    for(int i = 0; i < 1e4; i++) {
        int md = gen()%99+1;
        int num = gen()%md+1;

        string numString = to_string(num);
        for(auto &x: numString) x = SAMPLE[x-'0'];

        cout << md << ' ' << numString << endl;
    }
}

set<char> leq[10];

int main() {
#ifdef LOCAL
    freopen("../input.txt", "r", stdin);
    freopen("../debug.txt", "w", stderr);
#endif
    ios_base::sync_with_stdio(false);

//    populateInputFile();
//    return 0;

    int T; cin >> T;

    for(int no = 1; no <= T; no++) {
        int n; cin >> n;

        for(int i = 0; i < 10; i++) {
            leq[i].clear();
        }

        for(int i = 0; i < nodeCount; i++) {
            nxt[i].clear();
            cnt[i].clear();
        }

        nodeCount = 1;
        map<char, int> digitCount;
        set<char> notZero;

        string res = "";
        string str, md;
        set<char> alphabets;
        for(int i = 0; i < 10000; i++) {
            cin >> md >> str;
            if(md != "-1" && md.length() == str.length()) {
                leq[md[0]-'0'].insert(str[0]);
            }
            notZero.insert(str[0]);
            digitCount[str[0]]++;
            if(str.length() > 1) alphabets.insert(str[1]);
        }

        for(auto x: alphabets) {
            if(!notZero.count(x)) res += x;
        }

        for(auto a: digitCount) {
            res += a.first;
        }

        if(leq[9].size()) {
#ifdef LOCAL
            sort(res.begin()+1, res.end(), [&digitCount](char x, char y) {
                return digitCount[x] > digitCount[y];
            });
#else
            for(int i = 1; i < 10; i++) {
                for(int j = i; j < 10; j++) {
                    if(leq[i].count(res[j])) {
                        swap(res[i], res[j]);
                        break;
                    }
                }
            }
#endif
        } else {
            sort(res.begin()+1, res.end(), [&digitCount](char x, char y) {
                return digitCount[x] > digitCount[y];
            });
        }

        cout << "Case #" << no << ": " << res << endl;
    }
    return 0;
}
